/*=============================================
  SUBIENDO LA FOTO DEL USUARIO
=============================================*/

$(".nuevaFoto").change(function() {

  /*SE ALMACENA EN IMAGEN EL RESULTADO DE LA PROPIEDAD THIS.files
  ES UNA PROPIEDAD QUE SE GENERA EN LOS INPUT DEL TIPO FILE
  */

  var imagen = this.files[0];
  console.log("imagen", imagen);

  /*
    Validar si el formato es JPG o PNG
  */

  if (imagen["type"] != "image/jpeg" && imagen["type"] != "image/png") {

    /* SE LIMPIA EL INPUT DEL ARCHIVO ELEGIDO YA QUE EL ARCHIVO NO PROCEDE*/
    $(".nuevaFoto").val("");
    swal({
      title: "Error al subir Imágen",
      text: "¡La imágen debe estar en formato JPG o PNG!",
      type: "error",
      confirmButtonText: "¡Cerrar!"
    });
  } else {

    if (imagen["size"] > 2000000) {
      /* SE LIMPIA EL INPUT DEL ARCHIVO ELEGIDO YA QUE EL ARCHIVO NO PROCEDE*/
      $(".nuevaFoto").val("");
      swal({
        title: "Error al subir Imágen",
        text: "¡La imágen no debe pesar mas de 2 Mb!",
        type: "error",
        confirmButtonText: "¡Cerrar!"
      });
    } else {

      var datosImagen = new FileReader;
      datosImagen.readAsDataURL(imagen);
      $(datosImagen).on("load", function(event) {
        var rutaImagen = event.target.result;
        $(".previsualizar").attr("src", rutaImagen);
      })
    }
  }
})

/*=============================================
  EDITAR USUARIO
=============================================*/
$(document).on("click", ".btnEditarUsuario", function() {

  var idUsuario = $(this).attr("idUsuario");
  var datos = new FormData();
  datos.append("idUsuario", idUsuario);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/users.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {

      console.log("Respuesta", respuesta);
      //EL AJAX REGRESA LOS REGISTROS ENCONTRADOS SEGUN EL ID QUE SE LE MANDO

      //Y LOS PASA A LOS VALORES ID EN LAS ETIQUETAS DE la pagina usuarios.pjp
      $("#editarNombre").val(respuesta["us_nombre"]);
      $("#editarUsuario").val(respuesta["us_usuario"]);
      //	$("#editarRol").html(respuesta["rol_descripcion"]); // Como el Rol esta en un Select, se usa el elemento html para que se muestre
      $("#editarRol").val(respuesta["us_rol"]); // Aparte se le envia también el campo del rol al atributp Val para que se mantenga en el ID
      $("#EditarCorreo").val(respuesta["us_correo"]);
      $("#fotoActual").val(respuesta["us_foto"]);
      $("#passwordActual").val(respuesta["us_password"]);

      if (respuesta["us_foto"] != "") {
        // Si el campo us_foto no esta vacio
        //La clase previsualizar se reemplaza con la foto en la base de datos
        $(".previsualizar").attr("src", respuesta["us_foto"]); // Se pasa la ruta de la foto al atributo 'src'
      }
    }
  });
})

/*=============================================
ACTIVAR USUARIO
=============================================*/
$(document).on("click", ".btnActivar", function() {

  var idUsuario = $(this).attr("idUsuario");
  var estadoUsuario = $(this).attr("estadoUsuario");
  var datos = new FormData();

  datos.append("activarId", idUsuario);
  datos.append("activarUsuario", estadoUsuario);

  $.ajax({
    url: "ajax/users.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    success: function(respuesta) {
      //console.log("Respuesta",respuesta);
      if (window.matchMedia("(max-width:767px)").matches) {
        swal({
          title: "El usuario ha sido actualizado",
          type: "success",
          confirmButtonText: "¡Cerrar!"
        }).then(function(result) {
          if (result.value) {
            window.location = "usuarios";
          }
        });
      }
    }
  })

  if (estadoUsuario == 0) {
    $(this).removeClass('btn-success');
    $(this).addClass('btn-danger');
    $(this).html('Desactivado');
    $(this).attr('estadoUsuario', 1);
  } else {
    $(this).addClass('btn-success');
    $(this).removeClass('btn-danger');
    $(this).html('Activado');
    $(this).attr('estadoUsuario', 0);
  }
})

/*=============================================
    REVISAR SI YA EXISTE USUARIO CON EL MISMO USER NAME
=============================================*/
$("#nuevoUsuario").change(function() {
  //se remueven los mensajes de alerta en caso de que ya exista una alerta
  $(".alert").remove();
  var usuario = $(this).val();
  var datos = new FormData();
  datos.append("validarUsuario", usuario);

  $.ajax({
    url: "ajax/users.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {

      if (respuesta) {
        //console.log ("respuesta",respuesta)
        //.parent().after = AGREGA EL DIV DESPUES DEL DIV EN CUESTION.
        $("#nuevoUsuario").parent().after('<div class="alert alert-warning">Este usuario ya existe en la base de datos</div>');
        $("#nuevoUsuario").val("");
      }
    }
  })
})

/*=============================================
ELIMINAR USUARIO
=============================================*/
$(document).on("click", ".btnEliminarUsuario", function() {

  var idUsuario = $(this).attr("idUsuario");
  var fotoUsuario = $(this).attr("fotoUsuario");
  var usuario = $(this).attr("usuario");

  swal({
    title: '¿Está seguro de borrar el usuario?',
    text: "¡Usted puede cancelar la orden!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    cancelButtonText: 'Cancelar',
    confirmButtonText: 'Si, borrar usuario!'
  }).then(function(result) {

    if (result.value) {
      window.location = "index.php?ruta=usuarios&idUsuario=" + idUsuario + "&usuario=" + usuario + "&fotoUsuario=" + fotoUsuario;
    }
  })
})
