<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>
      Gestión de Usuarios
    </h1>
    <ol class="breadcrumb">
      <li><a href="inicio"><i class="fa fa-dashboard"></i> Inicio</a></li>
      <li><a href="#">Gestión de Usuarios</a></li>

    </ol>
  </section>


  <section class="content">

    <div class="box">

      <div class="box-header with-border">

        <button class="btn btn-primary" data-toggle="modal" data-target="#modalAgregarUsuario">

          Agregar Usuario

        </button>

      </div>
      <div class="box-body">

        <table class="table table-bordered table-striped dt-responsive tables" width="100%">

         <thead>

          <tr>

            <th style="width:10px">#</th>
            <th>Nombre</th>
            <th>Usuario</th>
            <th>Foto</th>
            <th>Rol</th>
            <th>Estado</th>
            <th>Último Login</th>
            <th>Acciones</th>

          </tr>

         </thead>

         <tbody>

          <?php
            $item = null;
            $valor = null;

            $usuarios = ControladorUsuarios::ctrMostrarUsuarios($item,$valor);

            foreach ($usuarios as $key => $value) {
                //var_dump($value['us_nombre']);

                echo '<tr>
                  <td>'.$value['id_usuario'].'</td>
                  <td>'.$value['us_nombre'].'</td>
                  <td>'.$value['us_usuario'].'</td>';

                  if ($value['us_foto'] != "") {
                    echo '<td><img src="'.$value['us_foto'].'" class="img-thumbnail" width="40px"></td>';
                  }else {
                    echo '<td><img src="views/img/users/default/anonymous.png" class="img-thumbnail" width="40px"></td>';
                  }

                  echo '<td>'.$value['rol_descripcion'].'</td>';

                  if ($value['us_status'] == 1) {
                    //SI EL STATUS ES 1 SE MUESTRA ACTIVADO EL USUARIO.
                    //EN EL ATRIBUTO estadoUsuario DEL BOTON SE MUESTRA 0 PARA QUE AL PRESIONARLO HAGA EL CAMBIO DE STATUS A ESE ESTADO
                      echo '<td><button class="btn btn-success btn-xs btnActivar" idUsuario="'.$value["id_usuario"].'" estadoUsuario="0">Activado</button></td>';
                  }else {
                    //SI EL STATUS ES 0 SE MUESTRA DESACTIVADO EL USUARIO.
                    // EN EL ATRIBUTO estadoUsuario DEL BOTON SE MUESTRA 1 PARA QUE AL PRESIONARLO HAGA EL CAMBIO DE STATUS A ESE ESTADO
                    echo '<td><button class="btn btn-danger btn-xs btnActivar" idUsuario="'.$value["id_usuario"].'" estadoUsuario="1">Desactivado</button></td>';
                  }

                  echo '<td>'.$value['us_ultimologin'].'</td>
                  <td>
                    <div class="btn-group">


                      <button class="btn btn-warning btnEditarUsuario" idUsuario="'.$value["id_usuario"].'" data-toggle="modal" data-target="#modalEditarUsuario"  data-toggle="modal" data-target="#modalEditarUsuario"><i class="fa fa-pencil"></i></button>

                      <button class="btn btn-danger btnEliminarUsuario" idUsuario="'.$value["id_usuario"].'" fotoUsuario="'.$value["us_foto"].'" usuario="'.$value["us_usuario"].'"><i class="fa fa-times"></i></button>
                    </div>
                  </td>
                </tr>';

              }

           ?>

         </tbody>

        </table>
      </div>

    </div>

  </section>
</div>

<!--===========================================
    VENTANA MODAL
===========================================-->

<div id="modalAgregarUsuario" class="modal fade" role="dialog">

  <div class="modal-dialog">

    <div class="modal-content">

      <form role="form" method="post" enctype="multipart/form-data">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->

        <div class="modal-header" style="background:#3c8dbc; color:white">

          <button type="button" class="close" data-dismiss="modal">&times;</button>

          <h4 class="modal-title">Agregar Usuario</h4>

        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->

        <div class="modal-body">

          <div class="box-body">

            <!-- ENTRADA PARA EL NOMBRE -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-user"></i></span>

                <input type="text" class="form-control input-lg" name="nuevoNombre" placeholder="Ingresar Nombre" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL USUARIO -->

             <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-key"></i></span>

                <input type="text" class="form-control input-lg" name="nuevoUsuario" placeholder="Ingresar Usuario" id="nuevoUsuario" required>

              </div>

            </div>

            <!-- ENTRADA PARA LA CONTRASEÑA -->

             <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-lock"></i></span>

                <input type="password" class="form-control input-lg" name="nuevoPassword" placeholder="Ingresar Contraseña" required>

              </div>

            </div>

            <!-- ENTRADA PARA CORREO electronico -->

             <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-envelope-square"></i></span>

                <input type="text" class="form-control input-lg" name="nuevoCorreo" placeholder="Ingresar Correo Electronico" required>

              </div>

            </div>
            <!-- ENTRADA PARA SELECCIONAR SU PERFIL -->
            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-users"></i></span>

                <select class="form-control input-lg" name="nuevoRol" id="GetRoles">
                  <option value="0">Selecciona una Rol </option>
                  <?php
                    $item = null;
                    $valor = null;
                    $contacto = ControladorUsuarios::ctrMostrarRoles($item,$valor);
                    foreach ($contacto as $key => $value) {
                        //var_dump($value['us_nombre']);
                        echo '<option value='.$value['id_rol'].'>
                                '.$value['rol_descripcion'].'
                          </option>';
                    }?>

                </select>

              </div>
          </div>
            <!-- ENTRADA PARA SUBIR FOTO -->

             <div class="form-group">

              <div class="panel">SUBIR FOTO</div>

              <input type="file" class="nuevaFoto" name="nuevaFoto">

              <p class="help-block">Peso máximo de la foto 2MB</p>

              <img src="views/img/users/default/anonymous.png" class="img-thumbnail previsualizar" width="100px">

            </div>

          </div>

        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->

        <div class="modal-footer">

          <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Salir</button>

          <button type="submit" class="btn btn-primary">Guardar Usuario</button>

        </div>

        <?php

               $crearUsuario = new ControladorUsuarios();
               $crearUsuario -> ctrCrearUsuario();

             ?>

      </form>

    </div>





  </div>

</div>





<!--=====================================
MODAL EDITAR USUARIO
======================================-->

<div id="modalEditarUsuario" class="modal fade" role="dialog">

  <div class="modal-dialog">

    <div class="modal-content">

      <form role="form" method="post" enctype="multipart/form-data">

        <!--=====================================
        CABEZA DEL MODAL
        ======================================-->

        <div class="modal-header" style="background:#3c8dbc; color:white">

          <button type="button" class="close" data-dismiss="modal">&times;</button>

          <h4 class="modal-title">Editar usuario</h4>

        </div>

        <!--=====================================
        CUERPO DEL MODAL
        ======================================-->

        <div class="modal-body">

          <div class="box-body">

            <!-- ENTRADA PARA EL NOMBRE -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-user"></i></span>

                <input type="text" class="form-control input-lg" id="editarNombre" name="editarNombre" value="" required>

              </div>

            </div>

            <!-- ENTRADA PARA EL USUARIO -->

             <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-key"></i></span>

                <input type="text" class="form-control input-lg" id="editarUsuario" name="editarUsuario" value="" readonly>

              </div>

            </div>

            <!-- ENTRADA PARA LA CONTRASEÑA -->

             <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-lock"></i></span>

                <input type="password" class="form-control input-lg" name="editarPassword" placeholder="Escriba la nueva contraseña">

                <input type="hidden" id="passwordActual" name="passwordActual">

              </div>

            </div>

          <!-- ENTRADA PARA CORREO electronico -->

           <div class="form-group">
            <div class="input-group">
              <span class="input-group-addon"><i class="fa fa-envelope-square"></i></span>
              <input type="text" class="form-control input-lg" name="EditarCorreo" id="EditarCorreo" placeholder="Correo Electronico" required>
            </div>
          </div>
            <!-- ENTRADA PARA SELECCIONAR SU PERFIL -->

            <div class="form-group">

              <div class="input-group">

                <span class="input-group-addon"><i class="fa fa-users"></i></span>

                <select class="form-control input-lg" name="editarRol" id="editarRol">



                  <?php
                    $item = null;
                    $valor = null;
                    $contacto = ControladorUsuarios::ctrMostrarRoles($item,$valor);
                    foreach ($contacto as $key => $value) {
                        //var_dump($value['us_nombre']);
                        echo '<option value='.$value['id_rol'].'>
                                '.$value['rol_descripcion'].'
                          </option>';
                    }?>
                </select>

              </div>

            </div>

            <!-- ENTRADA PARA SUBIR FOTO -->

             <div class="form-group">

              <div class="panel">SUBIR FOTO</div>

              <input type="file" class="nuevaFoto" name="editarFoto">

              <p class="help-block">Peso máximo de la foto 2MB</p>

              <img src="views/img/users/default/anonymous.png" class="img-thumbnail previsualizar" width="100px">

              <input type="hidden" name="fotoActual" id="fotoActual">

            </div>

          </div>

        </div>

        <!--=====================================
        PIE DEL MODAL
        ======================================-->

        <div class="modal-footer">

          <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Salir</button>

          <button type="submit" class="btn btn-primary">Modificar usuario</button>

        </div>

     <?php

           $editarUsuario = new ControladorUsuarios();
           $editarUsuario -> ctrEditarUsuario();

        ?>

      </form>

    </div>

  </div>

</div>



<?php

  $borrarUsuario = new ControladorUsuarios();
  $borrarUsuario -> ctrBorrarUsuario();

?>
