<?php
  /**
   * By Uriel
   */
  require_once "conexion.php";
  class ModeloFolios{
    /*======================================= GET A ULTIMA FOLIO WHERE TIPO DE SERVICIO =============================================*/
    static public function mdlGetUltimoFolio($tabla, $servicio){
        switch ($servicio) {
          case 'Reparacion':
              $stmt = conexion::conectar()->prepare("SELECT SUBSTRING(folio_numero, -3) terminacion FROM $tabla where folio_tipo_servicio = '$servicio' order by id_folio desc  limit 1");
              $stmt->execute();
              $resultado = $stmt ->fetch();
                if($resultado != false){
                        $year = date("y");
                        $month = date("m");
                        $Result =  (int) $resultado['terminacion'];
                        $Result = $Result + 1;
                        if ($Result < 10) {
                          $Nuevo = (string) $Result;
                          $Nuevo = "R"."$year"."$month"."00".$Nuevo;
                          return $Nuevo;
                        }else if ($Result < 100){
                          $Nuevo = (string) $Result;
                          $Nuevo = "R"."$year"."$month"."0".$Nuevo;
                          return $Nuevo;
                        }else{
                          $Nuevo = (string) $Result;
                          $Nuevo = "R"."$year"."$month".$Nuevo;
                          return $Nuevo;
                        }
                }
                else{
                    $year = date("y");
                    $month = date("m");
                    $Nuevo = "R"."$year"."$month". "001";
                    return $Nuevo;
                }
          break;
          case 'Maquinados':
                $stmt = conexion::conectar()->prepare("SELECT SUBSTRING(folio_numero, -3) terminacion FROM $tabla where folio_tipo_servicio = '$servicio' order by id_folio desc  limit 1");
                $stmt->execute();
                $resultado = $stmt ->fetch();

                  if($resultado != false){
                          $year = date("y");
                          $month = date("m");
                          $Result =  (int) $resultado['terminacion'];
                          $Result = $Result + 1;
                          if ($Result < 10) {
                            $Nuevo = (string) $Result;
                            $Nuevo = "M"."$year"."$month"."00".$Nuevo;
                            return $Nuevo;
                          }else if ($Result < 100){
                            $Nuevo = (string) $Result;
                            $Nuevo = "M"."$year"."$month"."0".$Nuevo;
                            return $Nuevo;
                          }else{
                            $Nuevo = (string) $Result;
                            $Nuevo = "M"."$year"."$month".$Nuevo;
                            return $Nuevo;
                          }
                  }
                  else{
                      $year = date("y");
                      $month = date("m");
                      $Nuevo = "M"."$year"."$month". "001";
                      return $Nuevo;
                  }
            break;
            case 'Ventas':
                  $stmt = conexion::conectar()->prepare("SELECT SUBSTRING(folio_numero, -3) terminacion FROM $tabla where folio_tipo_servicio = '$servicio' order by id_folio desc  limit 1");
                  $stmt->execute();
                  $resultado = $stmt ->fetch();

                    if($resultado != false){
                            $year = date("y");
                            $month = date("m");
                            $Result =  (int) $resultado['terminacion'];
                            $Result = $Result + 1;
                            if ($Result < 10) {
                              $Nuevo = (string) $Result;
                              $Nuevo = "V"."$year"."$month"."00".$Nuevo;
                              return $Nuevo;
                            }else if ($Result < 100){
                              $Nuevo = (string) $Result;
                              $Nuevo = "V"."$year"."$month"."0".$Nuevo;
                              return $Nuevo;
                            }else{
                              $Nuevo = (string) $Result;
                              $Nuevo = "V"."$year"."$month".$Nuevo;
                              return $Nuevo;
                            }
                    }
                    else{
                        $year = date("y");
                        $month = date("m");
                        $Nuevo = "V"."$year"."$month". "001";
                        return $Nuevo;
                    }
              break;
              case 'Servicios':
                    $stmt = conexion::conectar()->prepare("SELECT SUBSTRING(folio_numero, -3) terminacion FROM $tabla where folio_tipo_servicio = '$servicio' order by id_folio desc  limit 1");
                    $stmt->execute();
                    $resultado = $stmt ->fetch();

                      if($resultado != false){
                              $year = date("y");
                              $month = date("m");
                              $Result =  (int) $resultado['terminacion'];
                              $Result = $Result + 1;
                              if ($Result < 10) {
                                $Nuevo = (string) $Result;
                                $Nuevo = "S"."$year"."$month"."00".$Nuevo;
                                return $Nuevo;
                              }else if ($Result < 100){
                                $Nuevo = (string) $Result;
                                $Nuevo = "S"."$year"."$month"."0".$Nuevo;
                                return $Nuevo;
                              }else{
                                $Nuevo = (string) $Result;
                                $Nuevo = "S"."$year"."$month".$Nuevo;
                                return $Nuevo;
                              }
                      }
                      else{
                          $year = date("y");
                          $month = date("m");
                          $Nuevo = "S"."$year"."$month". "01";
                          return $Nuevo;
                      }
                break;

          default:
            // code...
            break;
        }
        $stmt->close();
        $stmt=null;
    }
    static public function mdlMostrarLastId($tabla,$item,$valor){
        if ($item != null) {
          $stmt = conexion::conectar()->prepare("SELECT id_folio FROM $tabla WHERE $item = :$item ");
          $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
          $stmt ->execute();
          return $stmt ->fetch();
        }
        $stmt->close();
        $stmt=null;
    }
      /*CREAR Cotización*/
    static public function mdlInsertarFolio($tabla,$datos){
        #var_dump($datos);exit;
        $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_solicitud, fk_id_status_folio, folio_numero, folio_fecha_creado, folio_creado_por, folio_tipo_servicio) VALUES (:fk_id_solicitud, :fk_id_status_folio, :folio_numero, :folio_fecha_creado, :folio_creado_por, :folio_tipo_servicio)");

        $stmt->bindParam(":fk_id_solicitud", $datos["fk_id_solicitud"], PDO::PARAM_STR);
        $stmt->bindParam(":fk_id_status_folio", $datos["fk_id_status_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_numero", $datos["folio_numero"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_fecha_creado", $datos["folio_fecha_creado"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_creado_por", $datos["folio_creado_por"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_tipo_servicio", $datos["folio_tipo_servicio"], PDO::PARAM_STR);

        if($stmt->execute()){
          $item = "folio_numero";
          $id = ModeloFolios::mdlMostrarLastId($tabla, $item, $datos["folio_numero"]);
          return $id["id_folio"];
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlInsertarRequisicionMaterial($tabla,$datos){
        #var_dump($datos);exit;
        $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_folio, requiM_descripcion, requiM_cantidad, requiM_importe_mxn, requiM_importe_usd, requiM_total_mxn,requiM_total_usd, requiM_status, requiM_fecha,requiM_moneda, requiM_unidad_medida) VALUES (:fk_id_folio, :requiM_descripcion, :requiM_cantidad, :requiM_importe_mxn, :requiM_importe_usd, :requiM_total_mxn, :requiM_total_usd, :requiM_status, :requiM_fecha, :requiM_moneda, :requiM_unidad_medida)");

        $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_descripcion", $datos["requiM_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_cantidad", $datos["requiM_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_importe_mxn", $datos["requiM_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_importe_usd", $datos["requiM_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_total_mxn", $datos["requiM_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_total_usd", $datos["requiM_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_status", $datos["requiM_status"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_fecha", $datos["requiM_fecha"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_moneda", $datos["requiM_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_unidad_medida", $datos["requiM_unidad_medida"], PDO::PARAM_STR);

        if($stmt->execute()){
          return "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlInsertarRequisicionMano($tabla,$datos){
        #var_dump($datos);exit;
        $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_folio,requiMO_descripcion,requiMO_cantidad,requiMO_importe_mxn,requiMO_importe_usd,requiMO_total_mxn,requiMO_total_usd,requiMO_status,requiMO_fecha,requiMO_moneda,requiMO_unidad_medida) VALUES (:fk_id_folio, :requiMO_descripcion, :requiMO_cantidad, :requiMO_importe_mxn, :requiMO_importe_usd, :requiMO_total_mxn, :requiMO_total_usd, :requiMO_status, :requiMO_fecha, :requiMO_moneda, :requiMO_unidad_medida)");

        $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_descripcion", $datos["requiMO_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_cantidad", $datos["requiMO_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_importe_mxn", $datos["requiMO_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_importe_usd", $datos["requiMO_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_total_mxn", $datos["requiMO_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_total_usd", $datos["requiMO_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_status", $datos["requiMO_status"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_fecha", $datos["requiMO_fecha"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_moneda", $datos["requiMO_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_unidad_medida", $datos["requiMO_unidad_medida"], PDO::PARAM_STR);

        if($stmt->execute()){
          return "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlInsertarRequisicionIndirectos($tabla,$datos){
          #fk_id_folio, adicionalInd_descripcion, adicionalInd_cantidad, adicionalInd_importe_mxn, adicionalInd_importe_usd, adicionalInd_total_mxn,adicionalInd_total_usd, adicionalesInd_fecha
        $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_folio,adicionalInd_descripcion,adicionalInd_cantidad,adicionalInd_importe_mxn,adicionalInd_importe_usd,adicionalInd_total_mxn,adicionalInd_total_usd,adicionalInd_status,adicionalesInd_fecha,adicionalesInd_moneda, adicionalesInd_unidad_medida) VALUES (:fk_id_folio, :adicionalInd_descripcion, :adicionalInd_cantidad, :adicionalInd_importe_mxn, :adicionalInd_importe_usd, :adicionalInd_total_mxn, :adicionalInd_total_usd,:adicionalInd_status, :adicionalesInd_fecha, :adicionalesInd_moneda, :adicionalesInd_unidad_medida)");

        $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_descripcion", $datos["adicionalInd_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_cantidad", $datos["adicionalInd_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_importe_mxn", $datos["adicionalInd_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_importe_usd", $datos["adicionalInd_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_total_mxn", $datos["adicionalInd_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_total_usd", $datos["adicionalInd_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_status", $datos["adicionalInd_status"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalesInd_fecha", $datos["adicionalesInd_fecha"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalesInd_moneda", $datos["adicionalesInd_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalesInd_unidad_medida", $datos["adicionalesInd_unidad_medida"], PDO::PARAM_STR);

        if($stmt->execute()){
          return "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlInsertarRequisicionExternos($tabla,$datos){
      #fk_id_folio, requiE_descripcion, requiE_cantidad,requiE_importe_mxn,requiE_importe_usd,requiE_total_mxn,requiE_total_usd,requiE_status,requiE_fecha

        $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_folio,requiE_descripcion,requiE_cantidad,requiE_importe_mxn,requiE_importe_usd,requiE_total_mxn,requiE_total_usd,requiE_status,requiE_fecha,requiE_moneda, requiE_unidad_medida) VALUES (:fk_id_folio, :requiE_descripcion, :requiE_cantidad, :requiE_importe_mxn, :requiE_importe_usd, :requiE_total_mxn, :requiE_total_usd, :requiE_status, :requiE_fecha, :requiE_moneda, :requiE_unidad_medida)");
        $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_descripcion", $datos["requiE_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_cantidad", $datos["requiE_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_importe_mxn", $datos["requiE_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_importe_usd", $datos["requiE_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_total_mxn", $datos["requiE_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_total_usd", $datos["requiE_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_status", $datos["requiE_status"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_fecha", $datos["requiE_fecha"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_moneda", $datos["requiE_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_unidad_medida", $datos["requiE_unidad_medida"], PDO::PARAM_STR);

        if($stmt->execute()){
          return "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlMostrarFolios($tabla,$fechaInicial,$fechaFinal,$status,$respon){

      if ($fechaInicial == null) {

        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as F inner join tbl_solicitudes as M on F.fk_id_solicitud = M.id_solicitud inner join cat_status_folios as SF on F.fk_id_status_folio = SF.id_status_folio inner join tbl_directorio_empresas as E on M.fk_id_empresa = E.id_empresa inner join tbl_contactos as C on M.fk_id_contacto = C.id_contacto  left join cat_tipos_servicios as S on M.fk_id_tipoServicio = S.id_servicio inner join cat_divisas as di on di.id_moneda = E.id_divisa inner join cat_status_solicitud as st on M.fk_id_status = st.id_status_soli left join tab_usuarios as usu on M.soli_responsable = usu.id_usuario JOIN cat_formas_aprobacion AS FA on M.fk_id_forma_aprobacion = FA.id_forma_aprobacion where fk_id_status_folio like '%$status%' AND soli_responsable like '%$respon%'");
        $stmt ->execute();
        return $stmt ->fetchall();
      }elseif ($status == null and $respon = null) {

          $stmt = conexion::conectar()->prepare("select * from $tabla as F inner join tbl_solicitudes as M on F.fk_id_solicitud = M.id_solicitud inner join cat_status_folios as SF on F.fk_id_status_folio = SF.id_status_folio inner join tbl_directorio_empresas as E on M.fk_id_empresa = E.id_empresa inner join tbl_contactos as C on M.fk_id_contacto = C.id_contacto  left join cat_tipos_servicios as S on M.fk_id_tipoServicio = S.id_servicio inner join cat_divisas as di on di.id_moneda = E.id_divisa inner join cat_status_solicitud as st on M.fk_id_status = st.id_status_soli left join tab_usuarios as usu on M.soli_responsable = usu.id_usuario JOIN cat_formas_aprobacion AS FA on M.fk_id_forma_aprobacion = FA.id_forma_aprobacion ");
          if($stmt->execute()){
              return $stmt ->fetchall();
          }else{
            return  $stmt -> errorInfo();
          }
      }elseif($fechaInicial == $fechaFinal){

        $stmt = conexion::conectar()->prepare("select * from $tabla as F inner join tbl_solicitudes as M on F.fk_id_solicitud = M.id_solicitud inner join cat_status_folios as SF on F.fk_id_status_folio = SF.id_status_folio inner join tbl_directorio_empresas as E on M.fk_id_empresa = E.id_empresa inner join tbl_contactos as C on M.fk_id_contacto = C.id_contacto  left join cat_tipos_servicios as S on M.fk_id_tipoServicio = S.id_servicio inner join cat_divisas as di on di.id_moneda = E.id_divisa inner join cat_status_solicitud as st on M.fk_id_status = st.id_status_soli left join tab_usuarios as usu on M.soli_responsable = usu.id_usuario JOIN cat_formas_aprobacion AS FA on M.fk_id_forma_aprobacion = FA.id_forma_aprobacion WHERE F.folio_fecha_creado like '%$fechaInicial%' AND fk_id_status_folio = '$status' AND M.soli_responsable = '$respon'");
        if($stmt->execute()){
            return $stmt ->fetchall();
        }else{
          return  $stmt -> errorInfo();
        }
      }
      else {
        //var_dump($fechaInicial);exit;
        $stmt = conexion::conectar()->prepare("select * from $tabla as F inner join tbl_solicitudes as M on F.fk_id_solicitud = M.id_solicitud inner join cat_status_folios as SF on F.fk_id_status_folio = SF.id_status_folio inner join tbl_directorio_empresas as E on M.fk_id_empresa = E.id_empresa inner join tbl_contactos as C on M.fk_id_contacto = C.id_contacto  left join cat_tipos_servicios as S on M.fk_id_tipoServicio = S.id_servicio inner join cat_status_solicitud as st on M.fk_id_status = st.id_status_soli left join tab_usuarios as usu on M.soli_responsable = usu.id_usuario inner join cat_divisas as di on di.id_moneda = E.id_divisa JOIN cat_formas_aprobacion AS FA on M.fk_id_forma_aprobacion = FA.id_forma_aprobacion WHERE F.folio_fecha_creado BETWEEN '$fechaInicial' AND '$fechaFinal' AND fk_id_status_folio like '%$status%' AND M.soli_responsable like '%$respon%'");
        if($stmt->execute()){
            return $stmt ->fetchall();
        }else{
          return  $stmt -> errorInfo();
        }

      }
      $stmt->close();
      $stmt=null;
    }
    static public function mdlMostrarMaterialesReales($tabla,$item,$valor){
      if ($item !== null) {
        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as M inner join tbl_folios as S on M.fk_id_folio  = S.id_folio left join tbl_ordenescompradetalles as D on M.id_requi_material = D.fk_id_RequiMat left join tbl_ordenescompra as OC on D.fk_id_OC = OC.id_ordenCompra left join cat_proveedores as P on OC.id_proveedor = P.id_proveedor where M.$item = :$item");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    static public function mdlManoDeObraReales($tabla,$item,$valor){
      if ($item !== null) {
        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as MO inner join tbl_folios as S on MO.fk_id_folio  = S.id_folio where MO.$item = :$item");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    static public function mdlIndirectosAdicionales($tabla,$item,$valor){
      if ($item !== null) {
        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as Ind inner join tbl_folios as S on Ind.fk_id_folio  = S.id_folio where Ind.$item = :$item");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    static public function mdlExternosReales($tabla,$item,$valor){
      if ($item !== null) {
        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as Ext inner join tbl_folios as S on Ext.fk_id_folio  = S.id_folio where Ext.$item = :$item");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    /*actualiza el campo de notas generales + cambio en el status del folio*/
    static public function mdlUpdateNotasGenerales($tabla,$datos){

        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_notas_generales = :folio_notas_generales, fk_id_status_folio = :fk_id_status_folio WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_notas_generales", $datos["folio_notas_generales"], PDO::PARAM_STR);
        $stmt->bindParam(":fk_id_status_folio", $datos["fk_id_status_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlInsertarMovimiento($tabla,$datos){
      #fk_id_folio, requiE_descripcion, requiE_cantidad,requiE_importe_mxn,requiE_importe_usd,requiE_total_mxn,requiE_total_usd,requiE_status,requiE_fecha
      $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_folio, historial_creadoPor, historial_movimiento, historial_comentario, historial_fecha_registro, historial_modulo) VALUES (:fk_id_folio, :historial_creadoPor, :historial_movimiento, :historial_comentario, :historial_fecha_registro, :historial_modulo)");


        $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":historial_creadoPor", $datos["historial_creadoPor"], PDO::PARAM_STR);
        $stmt->bindParam(":historial_movimiento", $datos["historial_movimiento"], PDO::PARAM_STR);
        $stmt->bindParam(":historial_comentario", $datos["historial_comentario"], PDO::PARAM_STR);
        $stmt->bindParam(":historial_fecha_registro", $datos["historial_fecha_registro"], PDO::PARAM_STR);
        $stmt->bindParam(":historial_modulo", $datos["historial_modulo"], PDO::PARAM_STR);
        if($stmt->execute()){
          return "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlUpdateAvanceFolio($tabla,$datos){

        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_avance = :folio_avance, fk_id_status_folio = :fk_id_status_folio WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_avance", $datos["folio_avance"], PDO::PARAM_STR);
        $stmt->bindParam(":fk_id_status_folio", $datos["fk_id_status_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlUpdateInfoEquipo($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_modelo = :folio_modelo, folio_marca = :folio_marca, folio_numero_serie = :folio_numero_serie, folio_equipo = :folio_equipo,fk_id_status_folio = :fk_id_status_folio WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_modelo", $datos["folio_modelo"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_marca", $datos["folio_marca"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_numero_serie", $datos["folio_numero_serie"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_equipo", $datos["folio_equipo"], PDO::PARAM_STR);
        $stmt->bindParam(":fk_id_status_folio", $datos["fk_id_status_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    /*=============================================
      ACTUALIZAR LOS DATOS DE MATERIAL
    =============================================*/
    static public function mdlUpdateMaterialR($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiM_unidad_medida = :requiM_unidad_medida, requiM_descripcion = :requiM_descripcion, requiM_cantidad = :requiM_cantidad, requiM_importe_mxn = :requiM_importe_mxn, requiM_total_mxn = :requiM_total_mxn, requiM_moneda = :requiM_moneda, requiM_importe_usd = :requiM_importe_usd, requiM_total_usd = :requiM_total_usd, requiM_solicitante = :requiM_solicitante WHERE id_requi_material = :id_requi_material");
        $stmt->bindParam(":id_requi_material", $datos["id_requi_material"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_unidad_medida", $datos["requiM_unidad_medida"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_descripcion", $datos["requiM_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_cantidad", $datos["requiM_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_importe_mxn", $datos["requiM_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_total_mxn", $datos["requiM_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_moneda", $datos["requiM_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_importe_usd", $datos["requiM_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_total_usd", $datos["requiM_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiM_solicitante", $datos["requiM_solicitante"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlSumaTotalMaterialMXN($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(requiM_total_mxn) as total FROM $tabla WHERE fk_id_folio = $item and requiM_status = 'Orden de Compra'");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlSumaTotalMaterialesUSD($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(requiM_total_usd) as total FROM $tabla WHERE fk_id_folio = $item and requiM_status = 'Orden de Compra'");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlActualizarTotalesMaterial($tabla,$datos){
        #Se divide el total del apartado de materiales / la cantidad de piezas de la solicitud
        $divideMXN = (float) $datos['folio_totalMateriales_mxn'] / $datos['soli_cantidad_piezas'];
        $divideDlls = (float) $datos['folio_totalMateriales_usd'] / $datos['soli_cantidad_piezas'];

        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_totalMateriales_mxn = :folio_totalMateriales_mxn, folio_totalMateriales_usd = :folio_totalMateriales_usd, folio_sumInd_materiales_mxn = :folio_sumInd_materiales_mxn, folio_sumInd_materiales_usd = :folio_sumInd_materiales_usd WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_totalMateriales_mxn", $datos["folio_totalMateriales_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_totalMateriales_usd", $datos["folio_totalMateriales_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_materiales_mxn", $divideMXN, PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_materiales_usd", $divideDlls, PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;

    }
    static public function mdlSumatoriaDeTotales($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("SELECT (coalesce(folio_totalMateriales_mxn,0) + coalesce(folio_totalManoDeObra_mxn,0) + coalesce(folio_total_adicionales_mxn,0) + coalesce(folio_totalExternos_mxn,0)) as total FROM $tabla WHERE id_folio =  :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          $resultado = $stmt->fetch();
          if($resultado != false){
              $Result =  (float) $resultado['total'];
              $insert = ModeloFolios::mdlActualizarTotalFolio($tabla, $datos, $Result);
              return $insert;
            }
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlActualizarTotalFolio($tabla,$datos,$Result){

        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_total_mxn = :folio_total_mxn WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_total_mxn", $Result, PDO::PARAM_STR);

        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlSumatoriaDeTotalesDlls($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("SELECT (coalesce(folio_totalMateriales_usd,0) + coalesce(folio_totalManoDeObra_usd,0) + coalesce(folio_total_adicionales_usd,0) + coalesce(folio_totalExternos_usd,0)) as total FROM $tabla WHERE id_folio =  :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          $resultado = $stmt->fetch();
          if($resultado != false){
              $Result =  (float) $resultado['total'];
              $insert = ModeloFolios::mdlActualizarTotalFolioDlls($tabla, $datos, $Result);
              return $insert;
            }
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlActualizarTotalFolioDlls($tabla,$datos,$Result){

        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_total_usd = :folio_total_usd WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_total_usd", $Result, PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    /*actualiza los datos obtenidos desde el formulario de detallesSolicitud*/
    static public function mdlInsertMateriales($tabla,$datos){
      $status = "Creado";
      $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(fk_id_folio,requiM_unidad_medida,requiM_descripcion,requiM_cantidad,requiM_importe_mxn,requiM_total_mxn,requiM_moneda,requiM_importe_usd,requiM_total_usd,requiM_solicitante,requiM_status,requiM_fecha,requiM_estimado_tarde) VALUES (:fk_id_folio,:requiM_unidad_medida, :requiM_descripcion, :requiM_cantidad, :requiM_importe_mxn, :requiM_total_mxn, :requiM_moneda, :requiM_importe_usd, :requiM_total_usd,:requiM_solicitante,:requiM_status,:requiM_fecha,:requiM_estimado_tarde)");

      $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_unidad_medida", $datos["requiM_unidad_medida"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_descripcion", $datos["requiM_descripcion"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_cantidad", $datos["requiM_cantidad"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_importe_mxn", $datos["requiM_importe_mxn"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_total_mxn", $datos["requiM_total_mxn"], PDO::PARAM_STR); #
      $stmt->bindParam(":requiM_moneda", $datos["requiM_moneda"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_importe_usd", $datos["requiM_importe_usd"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_total_usd", $datos["requiM_total_usd"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_solicitante", $datos["requiM_solicitante"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_status", $status, PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_fecha", $datos["requiM_fecha"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiM_estimado_tarde", $datos["requiM_estimado_tarde"], PDO::PARAM_STR); #ya

      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlUpdateStatusMaterial($tabla,$datos){
      $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiM_status = :requiM_status, requiM_solicitante = :requiM_solicitante WHERE id_requi_material = :id_requi_material");
      $stmt->bindParam(":id_requi_material", $datos["id_requi_material"], PDO::PARAM_STR);
      $stmt->bindParam(":requiM_status", $datos["requiM_status"], PDO::PARAM_STR);
      $stmt->bindParam(":requiM_solicitante", $datos["requiM_solicitante"], PDO::PARAM_STR);
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlInsertManoDeObra($tabla,$datos){
      $status = "Creado";
      $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(fk_id_folio,requiMO_unidad_medida,requiMO_descripcion,requiMO_cantidad,requiMO_importe_mxn,requiMO_total_mxn,requiMO_moneda,requiMO_importe_usd,requiMO_total_usd,requiMO_solicitante,requiMO_status,requiMO_fecha, requiMO_estimado_tarde) VALUES (:fk_id_folio,:requiMO_unidad_medida, :requiMO_descripcion, :requiMO_cantidad, :requiMO_importe_mxn, :requiMO_total_mxn, :requiMO_moneda, :requiMO_importe_usd, :requiMO_total_usd,:requiMO_solicitante,:requiMO_status,:requiMO_fecha,:requiMO_estimado_tarde)");

      $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_unidad_medida", $datos["requiMO_unidad_medida"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_descripcion", $datos["requiMO_descripcion"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_cantidad", $datos["requiMO_cantidad"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_importe_mxn", $datos["requiMO_importe_mxn"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_total_mxn", $datos["requiMO_total_mxn"], PDO::PARAM_STR); #
      $stmt->bindParam(":requiMO_moneda", $datos["requiMO_moneda"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_importe_usd", $datos["requiMO_importe_usd"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_total_usd", $datos["requiMO_total_usd"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_solicitante", $datos["requiMO_solicitante"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_status", $status, PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_fecha", $datos["requiMO_fecha"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiMO_estimado_tarde", $datos["requiMO_estimado_tarde"], PDO::PARAM_STR); #ya
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlSumaTotalManoDeObraMXN($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(requiMO_total_mxn) as total FROM $tabla WHERE fk_id_folio = $item and requiMO_status = 'Aprobado'");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlSumaTotalManoDeObraUSD($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(requiMO_total_usd) as total FROM $tabla WHERE fk_id_folio = $item and requiMO_status = 'Aprobado'");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlActualizarTotalesManoDeObra($tabla,$datos){
        #Se divide el total del apartado de materiales / la cantidad de piezas de la solicitud
        $divideMXN = (float) $datos['folio_totalManoDeObra_mxn'] / $datos['soli_cantidad_piezas'];
        $divideDlls = (float) $datos['folio_totalManoDeObra_usd'] / $datos['soli_cantidad_piezas'];
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_totalManoDeObra_mxn = :folio_totalManoDeObra_mxn, folio_totalManoDeObra_usd = :folio_totalManoDeObra_usd, folio_sumInd_manoDeObra_mxn = :folio_sumInd_manoDeObra_mxn, folio_sumInd_manoDeObra_usd = :folio_sumInd_manoDeObra_usd WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_totalManoDeObra_mxn", $datos["folio_totalManoDeObra_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_totalManoDeObra_usd", $datos["folio_totalManoDeObra_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_manoDeObra_mxn", $divideMXN, PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_manoDeObra_usd", $divideDlls, PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;

    }
    static public function mdlUpdateManoDeObraR($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiMO_unidad_medida = :requiMO_unidad_medida, requiMO_descripcion = :requiMO_descripcion, requiMO_cantidad = :requiMO_cantidad, requiMO_importe_mxn = :requiMO_importe_mxn, requiMO_total_mxn = :requiMO_total_mxn, requiMO_moneda = :requiMO_moneda, requiMO_importe_usd = :requiMO_importe_usd, requiMO_total_usd = :requiMO_total_usd, requiMO_solicitante = :requiMO_solicitante WHERE id_requi_MdeObra = :id_requi_MdeObra");
        $stmt->bindParam(":id_requi_MdeObra", $datos["id_requi_MdeObra"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_unidad_medida", $datos["requiMO_unidad_medida"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_descripcion", $datos["requiMO_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_cantidad", $datos["requiMO_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_importe_mxn", $datos["requiMO_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_total_mxn", $datos["requiMO_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_moneda", $datos["requiMO_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_importe_usd", $datos["requiMO_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_total_usd", $datos["requiMO_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiMO_solicitante", $datos["requiMO_solicitante"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlUpdateStatusManoDeObra($tabla,$datos){

      $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiMO_status = :requiMO_status, requiMO_solicitante = :requiMO_solicitante WHERE id_requi_MdeObra = :id_requi_MdeObra");

      $stmt->bindParam(":id_requi_MdeObra", $datos["id_requi_MdeObra"], PDO::PARAM_STR);
      $stmt->bindParam(":requiMO_status", $datos["requiMO_status"], PDO::PARAM_STR);
      $stmt->bindParam(":requiMO_solicitante", $datos["requiMO_solicitante"], PDO::PARAM_STR);
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlInsertarIndirectos($tabla,$datos){
      $status = "Guardado";
      $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(fk_id_folio, adicionalesInd_unidad_medida, adicionalInd_descripcion, adicionalInd_cantidad, adicionalInd_importe_mxn, adicionalInd_total_mxn, adicionalesInd_moneda, adicionalInd_importe_usd, adicionalInd_total_usd,adicionalesInd_fecha,adicionalInd_solicitante, adicionalInd_status, adicionalInd_estimado_tarde) VALUES (:fk_id_folio, :adicionalesInd_unidad_medida, :adicionalInd_descripcion, :adicionalInd_cantidad, :adicionalInd_importe_mxn, :adicionalInd_total_mxn, :adicionalesInd_moneda, :adicionalInd_importe_usd, :adicionalInd_total_usd, :adicionalesInd_fecha,:adicionalInd_solicitante, :adicionalInd_status, :adicionalInd_estimado_tarde)");

      $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalesInd_unidad_medida", $datos["adicionalesInd_unidad_medida"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_descripcion", $datos["adicionalInd_descripcion"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_cantidad", $datos["adicionalInd_cantidad"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_importe_mxn", $datos["adicionalInd_importe_mxn"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_total_mxn", $datos["adicionalInd_total_mxn"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalesInd_moneda", $datos["adicionalesInd_moneda"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_importe_usd", $datos["adicionalInd_importe_usd"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_total_usd", $datos["adicionalInd_total_usd"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalesInd_fecha", $datos["adicionalesInd_fecha"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_solicitante", $datos["historial_creadoPor"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_status", $status, PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_estimado_tarde", $datos["adicionalInd_estimado_tarde"], PDO::PARAM_STR);


      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlSumaTotalIndirectos($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(adicionalInd_total_mxn) as total FROM $tabla WHERE fk_id_folio = $item");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlSumaTotalIndirectosDlls($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(adicionalInd_total_usd) as total FROM $tabla WHERE fk_id_folio = $item");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlActualizarTotalesIndirectos($tabla,$datos){
        #Se divide el total del apartado de materiales / la cantidad de piezas de la solicitud
        $divideMXN = (float) $datos['folio_total_adicionales_mxn'] / $datos['soli_cantidad_piezas'];
        $divideDlls = (float) $datos['folio_total_adicionales_usd'] / $datos['soli_cantidad_piezas'];

        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_total_adicionales_mxn = :folio_total_adicionales_mxn, folio_total_adicionales_usd = :folio_total_adicionales_usd, folio_sumInd_internos_mxn = :folio_sumInd_internos_mxn, folio_sumInd_internos_usd = :folio_sumInd_internos_usd  WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_total_adicionales_mxn", $datos["folio_total_adicionales_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_total_adicionales_usd", $datos["folio_total_adicionales_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_internos_mxn", $divideMXN, PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_internos_usd", $divideDlls, PDO::PARAM_STR);

        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    /*=============================================
      ACTUALIZAR datos de  tbl_adicional_indirectos
    =============================================*/
    static public function mdlEditIndirectos($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET adicionalesInd_unidad_medida = :adicionalesInd_unidad_medida, adicionalInd_descripcion = :adicionalInd_descripcion, adicionalInd_cantidad = :adicionalInd_cantidad, adicionalInd_importe_mxn = :adicionalInd_importe_mxn, adicionalInd_total_mxn = :adicionalInd_total_mxn, adicionalesInd_moneda = :adicionalesInd_moneda, adicionalInd_importe_usd = :adicionalInd_importe_usd, adicionalInd_total_usd = :adicionalInd_total_usd, adicionalesInd_fecha = :adicionalesInd_fecha, adicionalInd_solicitante = :adicionalInd_solicitante WHERE id_aIndirecto = :id_aIndirecto");

        $stmt->bindParam(":id_aIndirecto", $datos["id_aIndirecto"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalesInd_unidad_medida", $datos["adicionalesInd_unidad_medida"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_descripcion", $datos["adicionalInd_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_cantidad", $datos["adicionalInd_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_importe_mxn", $datos["adicionalInd_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_total_mxn", $datos["adicionalInd_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalesInd_moneda", $datos["adicionalesInd_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_importe_usd", $datos["adicionalInd_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_total_usd", $datos["adicionalInd_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalesInd_fecha", $datos["adicionalesInd_fecha"], PDO::PARAM_STR);
        $stmt->bindParam(":adicionalInd_solicitante", $datos["historial_creadoPor"], PDO::PARAM_STR);

        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    /*=============================================
      ACTUALIZAR LOS DATOS DE MATERIAL
    =============================================*/
    static public function mdlUpdateExternosR($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiE_unidad_medida = :requiE_unidad_medida, requiE_descripcion = :requiE_descripcion, requiE_cantidad = :requiE_cantidad, requiE_importe_mxn = :requiE_importe_mxn, requiE_total_mxn = :requiE_total_mxn, requiE_moneda = :requiE_moneda, requiE_importe_usd = :requiE_importe_usd, requiE_total_usd = :requiE_total_usd, requiE_solicitante = :requiE_solicitante WHERE id_requi_externo = :id_requi_externo");
        $stmt->bindParam(":id_requi_externo", $datos["id_requi_externo"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_unidad_medida", $datos["requiE_unidad_medida"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_descripcion", $datos["requiE_descripcion"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_cantidad", $datos["requiE_cantidad"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_importe_mxn", $datos["requiE_importe_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_total_mxn", $datos["requiE_total_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_moneda", $datos["requiE_moneda"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_importe_usd", $datos["requiE_importe_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_total_usd", $datos["requiE_total_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":requiE_solicitante", $datos["requiE_solicitante"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlSumaTotalExternoMXN($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(requiE_total_mxn) as total FROM $tabla WHERE fk_id_folio = $item and requiE_status = 'Aprobado'");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlSumaTotalExternoUSD($tabla, $item){
      $stmt = conexion::conectar()->prepare("SELECT sum(requiE_total_usd) as total FROM $tabla WHERE fk_id_folio = $item and requiE_status = 'Aprobado'");
      $stmt ->execute();
      return $stmt ->fetch();
    }
    static public function mdlActualizarTotalesExternos($tabla,$datos){
        #Se divide el total del apartado de materiales / la cantidad de piezas de la solicitud
        $divideMXN = (float) $datos['folio_totalExternos_mxn'] / $datos['soli_cantidad_piezas'];
        $divideDlls = (float) $datos['folio_totalExternos_usd'] / $datos['soli_cantidad_piezas'];

        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_totalExternos_mxn = :folio_totalExternos_mxn, folio_totalExternos_usd = :folio_totalExternos_usd, folio_sumInd_externos_mxn = :folio_sumInd_externos_mxn, folio_sumInd_externos_usd = :folio_sumInd_externos_usd WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_totalExternos_mxn", $datos["folio_totalExternos_mxn"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_totalExternos_usd", $datos["folio_totalExternos_usd"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_externos_mxn", $divideMXN, PDO::PARAM_STR);
        $stmt->bindParam(":folio_sumInd_externos_usd", $divideDlls, PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;

    }
    static public function mdlInsertarExternos($tabla,$datos){
      $status = "Creado";
      $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(fk_id_folio,requiE_unidad_medida,requiE_descripcion,requiE_cantidad,requiE_importe_mxn,requiE_total_mxn,requiE_moneda,requiE_importe_usd,requiE_total_usd,requiE_solicitante,requiE_status,requiE_fecha,requiE_estimado_tarde) VALUES (:fk_id_folio,:requiE_unidad_medida, :requiE_descripcion, :requiE_cantidad, :requiE_importe_mxn, :requiE_total_mxn, :requiE_moneda, :requiE_importe_usd, :requiE_total_usd,:requiE_solicitante,:requiE_status,:requiE_fecha, :requiE_estimado_tarde)");
      $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_unidad_medida", $datos["requiE_unidad_medida"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_descripcion", $datos["requiE_descripcion"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_cantidad", $datos["requiE_cantidad"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_importe_mxn", $datos["requiE_importe_mxn"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_total_mxn", $datos["requiE_total_mxn"], PDO::PARAM_STR); #
      $stmt->bindParam(":requiE_moneda", $datos["requiE_moneda"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_importe_usd", $datos["requiE_importe_usd"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_total_usd", $datos["requiE_total_usd"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_solicitante", $datos["requiE_solicitante"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_status", $status, PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_fecha", $datos["requiE_fecha"], PDO::PARAM_STR); #ya
      $stmt->bindParam(":requiE_estimado_tarde", $datos["requiE_estimado_tarde"], PDO::PARAM_STR); #ya
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlUpdateStatusAdicionalIndirecto($tabla,$datos){
      $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET adicionalInd_status = :adicionalInd_status, adicionalInd_solicitante = :adicionalInd_solicitante WHERE id_aIndirecto = :id_aIndirecto");
      $stmt->bindParam(":id_aIndirecto", $datos["id_aIndirecto"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_status", $datos["adicionalInd_status"], PDO::PARAM_STR);
      $stmt->bindParam(":adicionalInd_solicitante", $datos["adicionalInd_solicitante"], PDO::PARAM_STR);
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlUpdateStatusExterno($tabla,$datos){
      $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiE_status = :requiE_status, requiE_solicitante = :requiE_solicitante WHERE id_requi_externo = :id_requi_externo");
      $stmt->bindParam(":id_requi_externo", $datos["id_requi_externo"], PDO::PARAM_STR);
      $stmt->bindParam(":requiE_status", $datos["requiE_status"], PDO::PARAM_STR);
      $stmt->bindParam(":requiE_solicitante", $datos["requiE_solicitante"], PDO::PARAM_STR);
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlCountadorPartidasM($tabla,$value){
      if ($value == null) {
        $stmt = Conexion::conectar()->prepare("SELECT COUNT(id_requi_material) as contador FROM $tabla WHERE requiM_status = 'Por Aprobación'");
        if($stmt->execute()){
          return $stmt->fetch();
        }else{
          return  $stmt -> errorInfo();
        }
      }else {
        $stmt = Conexion::conectar()->prepare("SELECT COUNT(id_requi_material) as contador FROM $tabla WHERE requiM_status = 'Por Aprobación' and fk_id_folio = :fk_id_folio");
        $stmt->bindParam(":fk_id_folio", $value["id_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          return $stmt->fetch();
        }else{
          return  $stmt -> errorInfo();
        }
      }

        $stmt->close();
        $stmt = null;
    }
    static public function mdlCountadorPartidasMO($tabla,$valor){
        if ($valor == null) {
          $stmt = Conexion::conectar()->prepare("SELECT COUNT(id_requi_MdeObra) as contador FROM $tabla WHERE requiMO_status = 'Por Aprobación'");
          if($stmt->execute()){
            return $stmt->fetch();
          }else{
            return  $stmt -> errorInfo();
          }
        }else {
          $stmt = Conexion::conectar()->prepare("SELECT COUNT(id_requi_MdeObra) as contador FROM $tabla WHERE requiMO_status = 'Por Aprobación' and fk_id_folio = :fk_id_folio");
          $stmt->bindParam(":fk_id_folio", $value["id_folio"], PDO::PARAM_STR);
          if($stmt->execute()){
            return $stmt->fetch();
          }else{
            return  $stmt -> errorInfo();
          }
        }

        $stmt->close();
        $stmt = null;
    }
    static public function mdlCountadorPartidasE($tabla,$value){
      if ($value == null) {
        $stmt = Conexion::conectar()->prepare("SELECT COUNT(id_requi_externo) as contador FROM $tabla WHERE requiE_status = 'Por Aprobación'");
        if($stmt->execute()){
          return $stmt->fetch();
        }else{
          return  $stmt -> errorInfo();
        }
      }else {
        $stmt = Conexion::conectar()->prepare("SELECT COUNT(id_requi_externo) as contador FROM $tabla WHERE requiE_status = 'Por Aprobación' and fk_id_folio = :fk_id_folio");
        $stmt->bindParam(":fk_id_folio", $value["id_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          return $stmt->fetch();
        }else{
          return  $stmt -> errorInfo();
        }
      }

        $stmt->close();
        $stmt = null;
    }
    static public function mdlCambiarStatusBandera($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_bandera = :folio_bandera WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_bandera", $datos["folio_bandera"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlMostrarFoliosPendientes($tabla){

        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as F inner join tbl_solicitudes as M on F.fk_id_solicitud = M.id_solicitud inner join cat_status_folios as SF on F.fk_id_status_folio = SF.id_status_folio inner join tbl_directorio_empresas as E on M.fk_id_empresa = E.id_empresa inner join tbl_contactos as C on M.fk_id_contacto = C.id_contacto  left join cat_tipos_servicios as S on M.fk_id_tipoServicio = S.id_servicio inner join cat_divisas as di on di.id_moneda = E.id_divisa inner join cat_status_solicitud as st on M.fk_id_status = st.id_status_soli left join tab_usuarios as usu on M.soli_responsable = usu.id_usuario WHERE F.folio_bandera = 'True'");
        $stmt ->execute();
        return $stmt ->fetchall();
        $stmt->close();
        $stmt=null;
    }
    static public function mdlAprobarPartidaMaterial($tabla,$datos){
      $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiM_status = :requiM_status WHERE id_requi_material = :id_requi_material");
      $stmt->bindParam(":id_requi_material", $datos["id_requi_material"], PDO::PARAM_STR);
      $stmt->bindParam(":requiM_status", $datos["requiM_status"], PDO::PARAM_STR);
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlAprobarPartidaManoDeObra($tabla,$datos){
      $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiMO_status = :requiMO_status WHERE id_requi_MdeObra = :id_requi_MdeObra");
      $stmt->bindParam(":id_requi_MdeObra", $datos["id_requi_MdeObra"], PDO::PARAM_STR);
      $stmt->bindParam(":requiMO_status", $datos["requiMO_status"], PDO::PARAM_STR);
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlAprobarPartidaExterno($tabla,$datos){
      $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET requiE_status = :requiE_status WHERE id_requi_externo = :id_requi_externo");
      $stmt->bindParam(":id_requi_externo", $datos["id_requi_externo"], PDO::PARAM_STR);
      $stmt->bindParam(":requiE_status", $datos["requiE_status"], PDO::PARAM_STR);
      if($stmt->execute()){
        return  "ok";
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlGetComentariosRechazo($tabla,$item,$valor){

      if ($item !== null) {
        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as H inner join tbl_folios as S on H.fk_id_folio  = S.id_folio where H.$item = :$item and historial_movimiento like '%Rechazo%' ");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);

        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    static public function mdlGetStatusFolio($tabla){
      $stmt = conexion::conectar()->prepare("select * from $tabla where folio_descripcion <> 'Iniciado'");
      $stmt ->execute();
      return $stmt ->fetchall();
      $stmt->close();
      $stmt=null;
    }
    static public function mdlUpdateStatusFolio($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET fk_id_status_folio = :fk_id_status_folio WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":fk_id_status_folio", $datos["fk_id_status_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlGetHistorialFolio($tabla,$item,$valor){
      if ($item !== null) {
        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as H inner join tbl_folios as S on H.fk_id_folio  = S.id_folio where H.$item = :$item and historial_movimiento  NOT like '%Rechazo%' ");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        $stmt ->execute();
        return $stmt ->fetchall();
      }
      $stmt->close();
      $stmt=null;
    }
    static public function mdlGetUltimoFolioRM($tabla){
        $stmt = conexion::conectar()->prepare("SELECT SUBSTRING(rm_folio, -2) terminacion FROM $tabla order by id_remision desc  limit 1");
        $stmt->execute();
        $resultado = $stmt ->fetch();
        if($resultado != false){
            $year = date("y");
            $month = date("m");
            $Result =  (int) $resultado['terminacion'];
            $Result = $Result + 1;
            if ($Result < 10) {
              $Nuevo = (string) $Result;
              $Nuevo = "RM"."$year"."$month"."0".$Nuevo;
              return $Nuevo;
            }else {
              $Nuevo = (string) $Result;
              $Nuevo = "RM"."$year"."$month".$Nuevo;
              return $Nuevo;
            }
        }
        else{
            $year = date("y");
            $month = date("m");
            $Nuevo = "RM"."$year"."$month". "01";
            return $Nuevo;
        }
        $stmt->close();
        $stmt=null;
    }
    static public function mdlInsertarRemision($tabla,$datos){
      $stmt = Conexion::conectar()->prepare("INSERT INTO $tabla (fk_id_folio, fk_id_solicitud, rm_creado_por, rm_fecha_creado, rm_folio) VALUES (:fk_id_folio, :fk_id_solicitud, :rm_creado_por, :rm_fecha_creado, :rm_folio)");
      $stmt->bindParam(":fk_id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
      $stmt->bindParam(":fk_id_solicitud", $datos["fk_id_solicitud"], PDO::PARAM_STR);
      $stmt->bindParam(":rm_creado_por", $datos["rm_creado_por"], PDO::PARAM_STR);
      $stmt->bindParam(":rm_fecha_creado", $datos["rm_fecha_creado"], PDO::PARAM_STR);
      $stmt->bindParam(":rm_folio", $datos["rm_folio"], PDO::PARAM_STR);
      if($stmt->execute()){
        $item = "rm_folio";
        $id = ModeloFolios::mdlMostrarLastId_Remision($tabla, $item, $datos["rm_folio"]);
        return $id["id_remision"];
      }else{
        return  $stmt -> errorInfo();
      }
      $stmt->close();
      $stmt = null;
    }
    static public function mdlMostrarLastId_Remision($tabla,$item,$valor){
        if ($item != null) {
          $stmt = conexion::conectar()->prepare("SELECT id_remision FROM $tabla WHERE $item = :$item ");
          $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
          $stmt ->execute();
          return $stmt ->fetch();
        }
        $stmt->close();
        $stmt=null;
    }
    static public function mdlGetRM($tabla, $item, $valor){
      $stmt = conexion::conectar()->prepare("select * from $tabla AS R join tbl_folios AS F on R.fk_id_folio = F.id_folio join tbl_solicitudes AS S on R.fk_id_solicitud = S.id_solicitud join tbl_directorio_empresas as E on S.fk_id_empresa = E.id_empresa join tbl_contactos as C on S.fk_id_contacto = C.id_contacto WHERE R.$item = :$item ");
      $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
      $stmt ->execute();
      return $stmt ->fetchall();
      $stmt->close();
      $stmt=null;
    }

    static public function mdlUpdateNoFactura($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_NoFactura = :folio_NoFactura WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_NoFactura", $datos["folio_NoFactura"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlUpdateNoFacturaConStatus($tabla,$datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET folio_NoFactura = :folio_NoFactura, fk_id_status_folio = :fk_id_status_folio WHERE id_folio = :id_folio");
        $stmt->bindParam(":id_folio", $datos["fk_id_folio"], PDO::PARAM_STR);
        $stmt->bindParam(":folio_NoFactura", $datos["folio_NoFactura"], PDO::PARAM_STR);
        $stmt->bindParam(":fk_id_status_folio", $datos["fk_id_status_folio"], PDO::PARAM_STR);
        if($stmt->execute()){
          return  "ok";
        }else{
          return  $stmt -> errorInfo();
        }
        $stmt->close();
        $stmt = null;
    }
    static public function mdlGetStatus($tabla,$item,$valor){
      if ($item == null) {
        $stmt = conexion::conectar()->prepare("SELECT * FROM $tabla");
        $stmt ->execute();
        return $stmt ->fetchall();
        $stmt->close();
        $stmt=null;
      }
    }
    static public function mdlMostrarFoliosAjax($tabla,$item,$valor){
      if ($item == null) {
        #$stmt = conexion::conectar()->prepare("select * from $tabla");
        $stmt = conexion::conectar()->prepare("select * from $tabla as F inner join tbl_solicitudes as M on F.fk_id_solicitud = M.id_solicitud inner join cat_status_folios as SF on F.fk_id_status_folio = SF.id_status_folio inner join tbl_directorio_empresas as E on M.fk_id_empresa = E.id_empresa inner join tbl_contactos as C on M.fk_id_contacto = C.id_contacto  left join cat_tipos_servicios as S on M.fk_id_tipoServicio = S.id_servicio inner join cat_divisas as di on di.id_moneda = E.id_divisa inner join cat_status_solicitud as st on M.fk_id_status = st.id_status_soli left join tab_usuarios as usu on M.soli_responsable = usu.id_usuario JOIN cat_formas_aprobacion AS FA on M.fk_id_forma_aprobacion = FA.id_forma_aprobacion");
        $stmt ->execute();
        return $stmt ->fetchall();
      }else {
        $stmt = conexion::conectar()->prepare("select * from $tabla as F inner join tbl_solicitudes as M on F.fk_id_solicitud = M.id_solicitud inner join cat_status_folios as SF on F.fk_id_status_folio = SF.id_status_folio inner join tbl_directorio_empresas as E on M.fk_id_empresa = E.id_empresa inner join tbl_contactos as C on M.fk_id_contacto = C.id_contacto  left join cat_tipos_servicios as S on M.fk_id_tipoServicio = S.id_servicio inner join cat_status_solicitud as st on M.fk_id_status = st.id_status_soli left join tab_usuarios as usu on M.soli_responsable = usu.id_usuario inner join cat_divisas as di on di.id_moneda = E.id_divisa JOIN cat_formas_aprobacion AS FA on M.fk_id_forma_aprobacion = FA.id_forma_aprobacion WHERE F.id_folio = $valor");
        $stmt -> bindParam(":".$item,$valor, PDO::PARAM_STR);
        if($stmt->execute()){
            return $stmt ->fetch();
        }else{
          return  $stmt -> errorInfo();
        }
      }
      $stmt->close();
      $stmt=null;
    }

}
 ?>
