//validacion de formulario
$(document).ready(function() {

  $("#_guardarYGenerar").click(function(event) {
    sessionStorage.clear();
    guardaSolicitud_Detalles();
  });
  $("#btnGuardaSolicitud").click(function(event) {
    guardarTotalesSolicitud();
  });
  $("#btnEnviaraAprobacion").click(function(event) {
    swal({
      title: '¿Toda la información capturada es correcta?',
      text: "¡Usted puede cancelar la orden!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, Enviar!'
    }).then(function(result) {
      if (result.value) {
        enviaraAprobacion_solicitud();
      }
    });
  });
  $("#_selectDepartamento").on("change", function() {
    var id = $(this).val();
    cargarApardado(id);
  });
  $("#_btnGenerarDetallesSoli").click(function(event) {
    guardarDetallesDeSolicitud();
    VerificaElStatusDeApartados();
  });
  $(".btn-default").click(function(event) {
    var propiedad = $(this).prop("innerHTML");
    if (propiedad == "Agregar Material") {
      $("#_addMateriales").removeClass('hidden');
      $("#BtnAddPartidasMaterial").addClass('hidden');
      limpiarCajas_Solicitud();
    } else if (propiedad == "Agregar Mano de Obra") {
      $("#_addManoDeObra").removeClass('hidden');
      $("#BtnAddPartidasManoDeObra").addClass('hidden');
      limpiarCajasDeManoDeObra();
    } else if (propiedad == "Agregar Gastos Indirectos") {
      $("#_addIndirectos").removeClass('hidden');
      $("#BtnAddPartidasIndirectos").addClass('hidden');
      limpiarCajasDeIndirectos();
    } else if (propiedad == "Agregar Gastos Externos") {
      $("#_addExternos").removeClass('hidden');
      $("#BtnAddPartidasExternos").addClass('hidden');
      limpiarCajasDeExternos();
    } else if (propiedad == "Agregar Concepto") {
      $("#_addConceptos").removeClass('hidden');
      $("#BtnAddPartidasConceptos").addClass('hidden');
      limpiarCajasConceptos();
    }
  });

  $(".btnAddOrUpdatePartida_EnDetalles").click(function(event) {
    var val = $(this).val();
    if (val == "material") {
      //Insertamos los detalles del material a la solicitud
      InsertOrUpdateMaterial_Solicitud();
      //guardarPartidaMaterial(); no se usa por el momento
    } else if (val == "ManoDeObra") {
      InsertOrUpdateManoDeObra_Solicitud();
    } else if (val == "indirectos") {
      InsertOrUpdateIndirectos_Solicitud();
    } else if (val == "externos") {
      InsertOrUpdateExternos_Solicitud();
    } else if (val == "conceptos") {
      InsertOrUpdateConceptos_Solicitud();
    }
  });


  $('.table').on('click', '.btn-danger', function() {
    if ($(this).hasClass('DeleteMaterial')) {
      var idPartida = $(this).attr("idDelete");

      swal({
        title: '¿Está seguro de borrar el Material?',
        text: "¡Usted puede cancelar la orden!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar Material!'
      }).then(function(result) {
        if (result.value) {
          EliminarMaterial(idPartida);
        }
      });
    } else if ($(this).hasClass('DeleteManoDeObra')) {
      var idPartida = $(this).attr("idDelete");

      swal({
        title: '¿Está seguro de borrar el registro?',
        text: "¡Usted puede cancelar la orden!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar registro!'
      }).then(function(result) {
        if (result.value) {
          EliminarManoDeObra(idPartida);
        }
      });
    } else if ($(this).hasClass('DeleteIndirectos')) {
      var idPartida = $(this).attr("idDelete");

      swal({
        title: '¿Está seguro de borrar el registro?',
        text: "¡Usted puede cancelar la orden!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar registro!'
      }).then(function(result) {
        if (result.value) {
          EliminarIndirectos(idPartida);
        }
      });
    } else if ($(this).hasClass('DeleteExternos')) {
      var idPartida = $(this).attr("idDelete");

      swal({
        title: '¿Está seguro de borrar el registro?',
        text: "¡Usted puede cancelar la orden!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar registro!'
      }).then(function(result) {
        if (result.value) {
          EliminarExternos(idPartida);
        }
      });
    } else if ($(this).hasClass('DeleteConceptos')) {
      var idPartida = $(this).attr("idDelete");

      swal({
        title: '¿Está seguro de borrar el registro?',
        text: "¡Usted puede cancelar la orden!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, borrar registro!'
      }).then(function(result) {
        if (result.value) {
          EliminarConcepto(idPartida);
        }
      });
    }
  });

  /*==================================================================
      MULTIPLICA LA CANTIDAD DE PRIEZAS POR EL SUBTOTAL
  ==================================================================*/
  $("._cantidad").on("change", function() {
    if ($(this).hasClass('_material')) {
      var precio = $("#nuevoPrecioProducto_enMaterial").val();
      if (precio !== "") {
        var cantidad = $(this).val();
        var subt = parseFloat(precio) * parseInt(cantidad);
        var newsubt = subt.toFixed(2);
        $("#nuevoTotalProducto_enMaterial").val(newsubt);
      }
    } else if ($(this).hasClass('_manoDeObra')) {
      var precio = $("#nuevoPrecioProducto_enManoDeObra").val();
      if (precio !== "") {
        var cantidad = $(this).val();
        var subt = parseFloat(precio) * parseInt(cantidad);
        $("#nuevoTotalProducto_enManoDeObra").val(subt);
      }
    } else if ($(this).hasClass('_indirecto')) {
      var precio = $("#nuevoPrecioProducto_enIndirectos").val();
      if (precio !== "") {
        var cantidad = $(this).val();
        var subt = parseFloat(precio) * parseInt(cantidad);
        $("#nuevoTotalProducto_enIndirectos").val(subt);
      }
    } else if ($(this).hasClass('_externos')) {
      var precio = $("#nuevoPrecioProducto_enExternos").val();
      if (precio !== "") {
        var cantidad = $(this).val();
        var subt = parseFloat(precio) * parseInt(cantidad);
        $("#nuevoTotalProducto_enExternos").val(subt);
      }
    } else if ($(this).hasClass('_concepto')) {
      var precio = $("#nuevoPrecioProducto_EnConceptos").val();
      if (precio !== "") {
        var cantidad = $(this).val();
        var subt = parseFloat(precio) * parseInt(cantidad);
        $("#nuevoTotalProducto_EnConceptos").val(subt);
      }
    }
  });
  /*==================================================================
    ASIGNA EL PRECIO DEL SUBTOTAL AL INPUT DE TOTAL
  ==================================================================*/
  $("._subtotal").on("change", function() {

    /*=======MATERIALES==============*/
    if ($(this).hasClass('_subMaterial')) {
      var cantidad = $("#nuevaCantidadProducto_enMaterial").val();
      var sub = $(this).val();
      var total = parseFloat(sub) * parseInt(cantidad);
      var newTotal = total.toFixed(2);
      $("#nuevoTotalProducto_enMaterial").val(newTotal);
    } else if ($(this).hasClass('_subManoDeObra')) {
      var cantidad = $("#nuevaCantidadProducto_enManoDeObra").val();
      var sub = $(this).val();
      var total = parseFloat(sub) * parseInt(cantidad);
      $("#nuevoTotalProducto_enManoDeObra").val(total);
    } else if ($(this).hasClass('_subIndirectos')) {
      var cantidad = $("#nuevaCantidadProducto_enIndirectos").val();
      var sub = $(this).val();
      var total = parseFloat(sub) * parseInt(cantidad);
      $("#nuevoTotalProducto_enIndirectos").val(total);
    } else if ($(this).hasClass('_subExternos')) {
      var cantidad = $("#nuevaCantidadProducto_enExternos").val();
      var sub = $(this).val();
      var total = parseFloat(sub) * parseInt(cantidad);
      $("#nuevoTotalProducto_enExternos").val(total);
    } else if ($(this).hasClass('_subConcepto')) {
      var cantidad = $("#nuevaCantidadProducto_EnConceptos").val();
      var sub = $(this).val();
      var total = parseFloat(sub) * parseInt(cantidad);
      $("#nuevoTotalProducto_EnConceptos").val(total);
    }

  });
  $(".btnTerminar").click(function(event) {
    //Terminar Apartado de Materiales
    if ($(this).hasClass('_FinMaterial')) {
      swal({
        title: '¿Está seguro que ha terminado el apartado de Material?',
        text: "¡Usted ya no podra capturar más materiales!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          FinApartadoMateriales();
          //Activa el boton de btnReActivar
          $("._IniciaMaterial").removeClass('hidden');

        }
      });

    } else if ($(this).hasClass('_FinManoDeObra')) {
      swal({
        title: '¿Está seguro que ha terminado el apartado de Mano de Obra?',
        text: "¡Usted ya no podra capturar más partidas!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          FinApartadoManoDeObra();
          $("._IniciaManoDeObra").removeClass('hidden');

        }
      });

    } else if ($(this).hasClass('_FinIndirectos')) {
      swal({
        title: '¿Está seguro que ha terminado el apartado de Gastos Indirectos?',
        text: "¡Usted ya no podra capturar más partidas!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          FinApartadoIndirectos();
          $("._IniciaIndirectos").removeClass('hidden');

        }
      });

    } else if ($(this).hasClass('_FinExternos')) {
      swal({
        title: '¿Está seguro que ha terminado el apartado de Gastos Externos?',
        text: "¡Usted ya no podra capturar más partidas!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          FinApartadoExternos();
          $("._IniciaExternos").removeClass('hidden');

        }
      });

    }
  });
  $(".btnReActivar").click(function(event) {
    if ($(this).hasClass('_IniciaMaterial')) {
      swal({
        title: '¿Está seguro de reactivar el apartado de Materiales?',
        text: "¡Usted podra capturar más partidas!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          ReactivarApartadoMateriales();
          $("._FinMaterial").removeClass('hidden');

        }
      });

    } else if ($(this).hasClass('_IniciaManoDeObra')) {
      swal({
        title: '¿Está seguro de reactivar el apartado de Mano de Obra?',
        text: "¡Usted podra capturar más partidas!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          ReactivarApartadoManoDeObra();
          $("._FinManoDeObra").removeClass('hidden');
        }
      });

    } else if ($(this).hasClass('_IniciaIndirectos')) {
      swal({
        title: '¿Está seguro de reactivar el apartado de Gastos Indirectos?',
        text: "¡Usted podra capturar más partidas!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          ReactivarApartadoIndirectos();
          $("._FinIndirectos").removeClass('hidden');
        }
      });


    } else if ($(this).hasClass('_IniciaExternos')) {
      swal({
        title: '¿Está seguro de reactivar el apartado de Gastos Externos?',
        text: "¡Usted podra capturar más partidas!",
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        cancelButtonText: 'Cancelar',
        confirmButtonText: 'Si, Continuar!'
      }).then(function(result) {
        if (result.value) {
          ReactivarApartadoExternos();
          $("._FinExternos").removeClass('hidden');
        }
      });
    }
  });
  $("._btnFinaliarSoli").click(function(event) {
    FinalizarSolicitud();
  });
  $("._btnRechazarSoli").click(function(event) {
    RechazarSolicitudCoordinador();
  });
  $("._btnAprobarSoli").click(function(event) {
    AprobarSolicitudCoordinador();
  });


//  VerificaElStatusDeApartados();


  /*=======================================
  CONVIERTE SOLICITUD A FOLIO O ENVIA A STATUS 'por cotizar' o 'estimacion de costos'
  =========================================*/
  $(".ConvierteAFolio").click(function(event) {
    var idPartida = $(this).attr("idSolicitud");
    //sessionStorage._enviarSolicitud = idPartida;
//    document.location = "verSolicitud";
    document.location = "verSolicitud?ConvertirFolio=" + idPartida;
  });
  /*=======================================
  SE CONFIRMA QUE LA SOLICITUD SEA RECIBIDA POR CLIENTE
  =========================================*/
  $(".confirmacionS").click(function(event) {
    var idPartida = $(this).attr("idSolicitud");
    document.location = "verSolicitud?confirmacionS=" + idPartida;
  });

  /*=======================================
      SE APRUEBA LA SOLICITUD X ROL DE GERENTE
  =========================================*/
  $("#btnAprobarSolicitud").click(function(event) {
    swal({
      title: '¿Está seguro de aprobar esta solicitud?',
      text: "¡Usted ya no podra cambiar esta accion!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, Continuar!'
    }).then(function(result) {
      if (result.value) {
          AprobarSolicitud();
      }
    });
  });
  /*=======================================
      SE APRUEBA LA SOLICITUD X ROL DE GERENTE
  =========================================*/
  $("#btnRechazarSolicitud").click(function(event) {
    swal({
      title: '¿Está seguro de desea rechazar la solicitud?',
      text: "¡Usted ya no podra cambiar esta accion!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, Continuar!'
    }).then(function(result) {
      if (result.value) {
          $("#modalRechazarSolicitud").modal('show');
      }
    });
  });
  /*=======================================
    SE ACTIVA LA FUNCION PARA RECHAZAR LA SOLICITUD
  =========================================*/
  $("#_btnRechazaSolicitud").click(function(event) {
      RechazarSolicitud();
  });

  /*=======================================
      SE APRUEBA LA SOLICITUD X ROL DE GERENTE
  =========================================*/
  $("#btnCancelarSolicitud").click(function(event) {
    swal({
      title: '¿Está seguro de desea cancelar la solicitud?',
      text: "¡Usted ya no podra cambiar esta accion!",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, Continuar!'
    }).then(function(result) {
      if (result.value) {
          $("#modalCancelarSolicitud").modal('show');
      }
    });
  });


  /*=======================================
    SE ACTIVA LA FUNCION PARA RECHAZAR LA SOLICITUD
  =========================================*/
  $("#_btnCancelarSolicitud").click(function(event) {
      CancelarSolicitud();
  });
  /*=======================================
    FUNCION PARA GUARDAR ADJUNTOS
  =========================================*/
  $("._atachment").on("change", function() {
    //let form = document.getElementById('subir_archivos');
    var valor = $("#subir_archivos")[0];
    subirArchivos();
    $(".loading").removeClass('hidden');
    $("._atachment").val("");
  });
  validadEdit_Solicitud();

  $("._selectContactosWhereID").on("change", function() {
    var cuenta = $(this).val();
    $("#_paraCorreo").removeClass('hidden');
    $("#_paraCorreoCC").removeClass('hidden');
    $("#txtCuenta_correo").val(cuenta);
  });
  $("#_btnGuardarTiempoEntV").click(function(event) {
      SaveTiempoEntregaAdmin();
  });

  $(".btnConvertirAFolio").click(function(event) {
    convertirAFolio();
  });
  //Verifica que forma de aprobacion selecciona el users
  $("#_selectFormaDeAprobacion").on("change", function() {
    var valor = $(this).val();
    if (valor == "1") {
      $("._divOrdenDeCompra").removeClass('hidden');
      $("._divSinOrdenDeCompra").addClass('hidden');
    }else if(valor !== "") {
      $("._divSinOrdenDeCompra").removeClass('hidden');
      $("._divOrdenDeCompra").addClass('hidden');
    }else {
      $("._divOrdenDeCompra").addClass('hidden');
      $("._divSinOrdenDeCompra").addClass('hidden');
    }
  });
  $("#_cambiarTipoMoneda").change(function() {
    var value = $(this).val();
    var monedatxt = "";
    if (value == 1) {
      monedatxt = "USD";
    }else {
      monedatxt = "MXN"
    }
    swal({
      title: '¿Está seguro de desea cambiar el tipo de moneda?',
      text: "¡El tipo de moneda actual es! "+ monedatxt,
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, Continuar!'
    }).then(function(result) {
      if (result.value) {
          cambiarTipoMoneda();
      }else {
        if (value == 1) {
          $("#_cambiarTipoMoneda").val(2);
        }else {
          $("#_cambiarTipoMoneda").val(1);
        }
      }
    });
  })


  $("#btnEnviarAAdmin").click(function(event) {
    swal({
      title: '¿Está seguro de desea enviar la solicitud?',
      text: "¡La solicitud será enviada a Administración",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, Continuar!'
    }).then(function(result) {
      if (result.value) {
          enviarAAdmin();
      }
    });


  });
  $("#btnEnviarAVentas").click(function(event) {
    swal({
      title: '¿Está seguro de desea enviar la solicitud?',
      text: "¡La solicitud será enviada a el vendedor de campo",
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      cancelButtonText: 'Cancelar',
      confirmButtonText: 'Si, Continuar!'
    }).then(function(result) {
      if (result.value) {
        enviarAVentas();
      }
    });


  });
});

function validadEdit_Solicitud() {

  var sPaginaURL = window.location.search.substring(1);
  var sURLVariables = sPaginaURL.split('&');
  var sp = sPaginaURL.split('&');
  var sp1 = sURLVariables[0].split('=');

  switch (sp1[0]) {

    case "EditConceptos":
      //  alert(sp1[1]);
      $("#_Id_SolicitudConceptos").val(sp1[1]);
      CargarDatosParaEditEnConceptos();
      printMateriales_EnConceptos();
      printManoDeObra_EnConceptos();
      printIndirectos_EnConceptos();
      printExternos_EnConceptos();
      printConceptos();

      break;

    case "EditSoli":
    //  alert(sp1[1]);
      $("#_Id_Solicitud").val(sp1[1]);
    //  alert($("#_Id_Solicitud").val());
      CargarDatosParaEdit();
      printMateriales();
      printManoDeObra();
      printIndirectos();
      printExternos();
      totalDeSolicitud();
      VerificaStatusDeLaSolicitus();
      CargarDatos();
      printTblAdjuntos();
      break;

    case "AprobarSolicitud":
      $("#_Id_SolicitudAprobacion").val(sp1[1]);
      CargarDatosParaEditEnAprobacion();
      printMateriales_enAprobacion();
      printManoDeObra_EnAprobacion();
      printIndirectos_EnAprobacion();
      printExternos_EnAprobacion();
      printConceptos_enAprobacion();
      break;
      case "verSolicitud":
      $("#_Id_SolicitudVerSolicitud").val(sp1[1]);
      CargarDatosParaEditEnVerSolicitud();
      printMateriales_enverSolicitudn();
      printManoDeObra_EnverSolicitud();
      printIndirectos_EnverSolicitud();
      printExternos_EnVerSolicitud();
      printConceptos_enverSolicitud();
      printTblAdjuntos();
      printTblHistorialCorreos();
      break;
    case "EnviarSolicitud":
      //alert(sp1[1]);
      $("#_Id_SolicitudVerSolicitud").val(sp1[1]);
      $(".enviarCliente").removeClass('hidden');
      CargarDatosParaEditEnVerSolicitud();
      printMateriales_enverSolicitudn();
      printManoDeObra_EnverSolicitud();
      printIndirectos_EnverSolicitud();
      printExternos_EnVerSolicitud();
      printConceptos_enverSolicitud();
      printTblAdjuntos();
      break;
    case "ConvertirFolio":
    $("#_Id_SolicitudVerSolicitud").val(sp1[1]);
      CargarDatosParaEditEnVerSolicitud();
      printMateriales_enverSolicitudn();
      printManoDeObra_EnverSolicitud();
      printIndirectos_EnverSolicitud();
      printExternos_EnVerSolicitud();
      printConceptos_enverSolicitud();
      printTblAdjuntos();
      printTblHistorialCorreos();
      $(".enviarCliente").removeClass('hidden');
      $("._convierteAFolio").removeClass('hidden');


      break;
      case "confirmacionS":
      $("#_Id_SolicitudVerSolicitud").val(sp1[1]);
        CargarDatosParaEditEnVerSolicitud();
        printMateriales_enverSolicitudn();
        printManoDeObra_EnverSolicitud();
        printIndirectos_EnverSolicitud();
        printExternos_EnVerSolicitud();
        printConceptos_enverSolicitud();
        printTblAdjuntos();
        printTblHistorialCorreos();
        $(".btnFolio").addClass('hidden');
        $(".btnConfirmar").removeClass('hidden');
        break;
    default:
    ValidateSesion();
  }
}
/*
function validadEdit() {
  if (sessionStorage._idSolicitudEdit !== undefined) {
    $("#_Id_Solicitud").val(sessionStorage._idSolicitudEdit);
    CargarDatosParaEdit();

    printMateriales();
    printManoDeObra();
    printIndirectos();
    printExternos();
    totalDeSolicitud();
    VerificaStatusDeLaSolicitus();
    CargarDatos();
    printTblAdjuntos();
  } else {
    ValidateSesion();
  }
  if (sessionStorage._idSoliEditConceptos !== undefined) {
    $("#_Id_SolicitudConceptos").val(sessionStorage._idSoliEditConceptos);
    CargarDatosParaEditEnConceptos();
    printMateriales_EnConceptos();
    printManoDeObra_EnConceptos();
    printIndirectos_EnConceptos();
    printExternos_EnConceptos();
    printConceptos();
      sessionStorage.clear();
    //getTotalesSolicitud();
  } else {
    ValidateSesion();
  }
  if (sessionStorage._AprobarSolicitud !== undefined) {
    $("#_Id_SolicitudAprobacion").val(sessionStorage._AprobarSolicitud);
    CargarDatosParaEditEnAprobacion();
    printMateriales_enAprobacion();
    printManoDeObra_EnAprobacion();
    printIndirectos_EnAprobacion();
    printExternos_EnAprobacion();
    printConceptos_enAprobacion();
      sessionStorage.clear();
  } else {
    ValidateSesion();
  }
  if (sessionStorage._VerSolicitud !== undefined) {
    $("#_Id_SolicitudVerSolicitud").val(sessionStorage._VerSolicitud);
    CargarDatosParaEditEnVerSolicitud();
    printMateriales_enverSolicitudn();
    printManoDeObra_EnverSolicitud();
    printIndirectos_EnverSolicitud();
    printExternos_EnVerSolicitud();
    printConceptos_enverSolicitud();
    sessionStorage.clear();
  } else {
    ValidateSesion();
  }
  if (sessionStorage._enviarSolicitud !== undefined) {
      $("#_Id_SolicitudVerSolicitud").val(sessionStorage._enviarSolicitud);
      $(".enviarCliente").removeClass('hidden');

      CargarDatosParaEditEnVerSolicitud();
      printMateriales_enverSolicitudn();
      printManoDeObra_EnverSolicitud();
      printIndirectos_EnverSolicitud();
      printExternos_EnVerSolicitud();
      printConceptos_enverSolicitud();
        sessionStorage.clear();
    } else {
      ValidateSesion();
    }

}
*/
//Flat red color scheme for iCheck
$('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
  checkboxClass: 'icheckbox_flat-green',
  radioClass: 'iradio_flat-green'
})
$('#fechaDeVisita').datepicker();
//Timepicker
$('.timepiccker').timepicker({
  showInputs: false,
  timePickerIncrement: -14
});
$('#fechaDeVisitaRep').datepicker();
/*==================================================================
    Mostrar el select de contacto cuando sea cargado una empresa
==================================================================*/
$("#GetEmpresas_EnSolicitud").change(function() {
  var ValEmpresa = $(this).val();
  GetContactos(ValEmpresa, "");
})


$(document).on("click", ".btn-warning", function() {
  var idPartida = $(this).attr("idSoli");

  if ($(this).hasClass('EditMaterial')) {
    $("#_addMateriales").removeClass('hidden');
    GetDatosDeProducto(idPartida);
  } else if ($(this).hasClass('EditManoDeObra')) {
    $("#_addManoDeObra").removeClass('hidden');
    GetDatosDeManoDeObra(idPartida);
  } else if ($(this).hasClass('EditIndirectos')) {
    $("#_addIndirectos").removeClass('hidden');
    GetDatosIndirectos(idPartida);
  } else if ($(this).hasClass('EditExternos')) {
    $("#_addExternos").removeClass('hidden');
    GetDatosExternos(idPartida);
  } else if ($(this).hasClass('EditConceptos')) {
    $("#_addConceptos").removeClass('hidden');
    GetDatosConceptos(idPartida);
  }
});
/*==================================================================
  Funcion para cargar los contactos de acuerdo a la empresa
==================================================================*/
function GetContactos(idempresa, idContacto) {

  var datos = new FormData();
  datos.append("ValEmpresa", idempresa);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  // @ts-ignore
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      //  $("#seleccionarContacto").html("");
      //console.log("Respuesta", respuesta);
      var print = "";
      if (respuesta.length == 0) {
        print = "<option>No existen contactos para esta empresa</option>";

      } else {
        print = "<option>Seleccione un contacto</option>";
        for (var i = 0; i < respuesta.length; i++) {
          print += "<option value=" + respuesta[i]['id_contacto'] + ">";
          print += respuesta[i]['cont_nombre'];
          print += "</option>";
        }
      }

      // @ts-ignore
      $("#seleccionarCliente_EnSolicitud").html(print);
      // @ts-ignore
      $("#_SelectContacto").removeClass('hidden');
      if (idContacto != "") {
        // @ts-ignore
        $("#seleccionarCliente_EnSolicitud").val(idContacto);

      }
    }

  })
}
//---------- ACTIVAR APARTADO DE PROGRAMACION DE CITAS------------------
$("#progamarVisita").on("ifChecked", function() {
  if ($("#progamarVisita").prop("checked")) {
    $("#_divProgramar").removeClass("hidden");
  }
})
$("#progamarVisita").on("ifUnchecked", function() {
  $("#_divProgramar").addClass("hidden");
})
//Inserta las pertidas de los productos.
$(document).on("click", "#_guardarSolicitud", function() {
  //Tomar valores del formulario
  //var fechaActual = $("#datepicker_EnSolicitud").val();
  var empresa = $("#GetEmpresas_EnSolicitud").val();
  var contacto = $("#seleccionarCliente_EnSolicitud").val();
  var tituloSoli = $("#txtTitulo_EnSolicitud").val();
  var respon = $("#txtResponsable_EnSolicitud").val();
  var comoSeHace = $("#txtComoSeHace_EnSolicitud").val();
  var name = $("#_us_name_soli").val();
  var statusSolicitud = 1;
  var fechaVisita = "";
  var visitaProgramada = 0;
  if ($("#progamarVisita").prop("checked")) {
    fechaVisita = $("#fechaDeVisita").val() + " " + $("#horaVisita").val();
    visitaProgramada = 1;
    statusSolicitud = 2;
  }
  if (empresa == "" || contacto == "" || tituloSoli == "" || comoSeHace == "") {
    swal({
      type: "error",
      title: "¡Todos los campos marcados con * son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  } else {
    var dato = '{"fk_id_empresa":"' + empresa + '",';
    dato += '"fk_id_contacto":"' + contacto + '",';
    dato += '"soli_titulo":"' + tituloSoli + '",';
    dato += '"soli_responsable":"' + respon + '",';
    dato += '"soli_como_seHace":"' + comoSeHace + '",';
    dato += '"soli_visita_programada":"' + visitaProgramada + '",';

    dato += '"soli_fecha_visita":"' + fechaVisita + '",';
    dato += '"fk_id_status":"' + statusSolicitud + '",';
    dato += '"movSoli_creadoPor":"' + name + '"}';


    var datos = new FormData();
    datos.append("InsertarSoli", dato);

    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta != "") {
          swal({
            type: "success",
            title: "¡Datos registrados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {
              document.location = "solicitudes";
            }
          });
          document.getElementById('GetEmpresas_EnSolicitud').getElementsByTagName('option')[0].selected = 'selected';
          //$("#GetEmpresas_EnSolicitud").val("0");
          document.getElementById('_SelectContacto').getElementsByTagName('option')[0].selected = 'selected';
          //$("#_SelectContacto").val("0");
          $("#txtTitulo_EnSolicitud").val("");
          document.getElementById('txtResponsable_EnSolicitud').getElementsByTagName('option')[0].selected = 'selected';
          //$("#txtResponsable_EnSolicitud").val("0");
          $("#txtComoSeHace_EnSolicitud").val("");
          $("#modalAgregarSolicitud").modal('hide');
          $("#fechaDeVisita").val("");
          $("#horaVisita").val();
          //$("#progamarVisita").removeClass("checked");
          //$("#progamarVisita").prop('checked', false);

          //$("#progamarVisita").prop("checked",false).trigger("change");
          $('#progamarVisita').prop('checked', false);

        }
      }
    });
  }

});

function pintarSolicitudes() {
  DestroyTable();
  var valor = 0;
  var datos = new FormData();
  datos.append("_Valor", valor);
  var idRol = $("#_us_rol").val();
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalDescuento = 0;
      for (var i = 0; i < respuesta.length; i++) {
          print += "<tr>";
          print += "<td>" + respuesta[i]['id_solicitud'] + "</td>";
          print += "<td>" + respuesta[i]['soli_folio'] + "</td>";
          print += "<td>" + respuesta[i]['soli_titulo'] + "</td>";
          if (respuesta[i]['us_nombre']) {
            print += "<td>" + respuesta[i]['us_nombre'] + "</td>";
          } else {
            print += "<td><span class='label label-danger'>No asignada</span></td>";
          }
          print += "<td>" + respuesta[i]['emp_nombre'] + "</td>";
          print += "<td>" + respuesta[i]['cont_nombre'] + "</td>";
          print += "<td>" + respuesta[i]['status_descripcion'] + "</td>";

          print += "<td>";
          print += "<div class='btn-group'>";

          if (respuesta[i]['id_status_soli'] == "4" && idRol == "8") {
            print += "<a class='btn btn-warning EditarSoliAdmin' idSolicitud = " + respuesta[i]['id_solicitud'] + " ><i class='fa fa-pencil'></i></a>";
            print += "<button type='button' class='btn btn-danger btnDeleteCotizacion' idSolicitud=" + respuesta[i]['id_solicitud'] + "><i class='fa fa-times'></i></button>";
          } else if (respuesta[i]['us_nombre'] == null || respuesta[i]['us_nombre'] == "" && idRol == "3") {
            print += "<a class='btn btn-warning AsignarSolicitud' idSolicitud=" + respuesta[i]["id_solicitud"] + "><i class='fa fa-pencil'></i></a>";
            print += "<button type='button' class='btn btn-danger btnDeleteCotizacion' idSolicitud=" + respuesta[i]['id_solicitud'] + "><i class='fa fa-times'></i></button>";
          } else if (respuesta[i]['id_status_soli'] == "5" && idRol == "5") {
            print += "<a class='btn btn-warning AprobarSolicitud' idSolicitud = " + respuesta[i]['id_solicitud'] + " ><i class='fa fa-pencil'></i></a>";
            print += "<button type='button' class='btn btn-danger btnDeletCotizacion' idSolicitud=" + respuesta[i]['id_solicitud'] + "><i class='fa fa-times'></i></button>";
          } else if (respuesta[i]['id_status_soli'] == "1" && idRol == "6" || respuesta[i]['id_status_soli'] == "2" && idRol == "6" || respuesta[i]['id_status_soli'] == "3" && idRol == "6") {
            print += "<a class='btn btn-warning EditarSolicitud' idSolicitud = " + respuesta[i]['id_solicitud'] + " ><i class='fa fa-pencil'></i></a>";
            print += "<button type='button' class='btn btn-danger btnDeleteCotizacion' idSolicitud=" + respuesta[i]['id_solicitud'] + "><i class='fa fa-times'></i></button>";
          } else if (respuesta[i]['id_status_soli'] == "6" && idRol == "8") {
            print += "<a class='btn btn-warning EnviarACliente' idSolicitud = " + respuesta[i]['id_solicitud'] + " ><i class='fa fa-pencil'></i></a>";
            print += "<button type='button' class='btn btn-success btnDeleteCotizacion' idSolicitud=" + respuesta[i]['id_solicitud'] + "><i class='fa fa-times'></i></button>";
          }
          print += "<a class='btn btn-info InformacionGeneral' idSolicitud = " + respuesta[i]['id_solicitud'] + " ><i class='fa fa-info-circle'></i></a>";
          print += "</div>";

          print += "</td>";
          print += "</tr>";
      }
      $("#printSolicitudes").html(print);
      sessionStorage.clear();
      Table();
    }
  })
}
//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTable() {
  var table = $('#tablaSolicitudes').DataTable();
  table.destroy();
}
//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTableMateriales() {
  var table = $('#tablaMateriales').DataTable();
  table.destroy();
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function TableMateriales() {
  $('#tablaMateriales').DataTable({
    "bPaginate": false,
    "bFilter": false,
    "bInfo": false,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function Table() {
  $('#tablaSolicitudes').DataTable({
    "bPaginate": false,
    "bFilter": false,
    "bInfo": false,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}

function ValidateModal() {
  $("#SolicitudForm").validate({
    rules: {
      txtTitulo_EnSolicitud: "required",
      txtComoSeHace_EnSolicitud: "required"

    },
    messages: {
      txtTitulo_EnSolicitud: "Introducir el Nombre del Empleado.",
      txtComoSeHace_EnSolicitud: "Introducir los Apellidos del Empleado."
    },

    submitHandler: function(form) {}
  });
}


function guardaSolicitud_Detalles() {

  //Tomar valores del formulario
  //var fechaActual = $("#datepicker_EnSolicitud").val();
  var empresa = $("#GetEmpresas_EnSolicitud").val();
  var contacto = $("#seleccionarCliente_EnSolicitud").val();
  var tituloSoli = $("#txtTitulo_EnSolicitud").val();
  var respon = $("#txtResponsable_EnSolicitud").val();
  var comoSeHace = $("#txtComoSeHace_EnSolicitud").val();
  var statusSolicitud = 1;
  var fechaVisita = "";
  var visitaProgramada = 0;
  if ($("#progamarVisita").prop("checked")) {
    fechaVisita = $("#fechaDeVisita").val() + " " + $("#horaVisita").val();
    visitaProgramada = 1;
    statusSolicitud = 2;
  }
  if (empresa == "" || contacto == "" || tituloSoli == "" || comoSeHace == "") {
    swal({
      type: "error",
      title: "¡Todos los campos marcados con * son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  } else {
    var dato = '{"fk_id_empresa":"' + empresa + '",';
    dato += '"fk_id_contacto":"' + contacto + '",';
    dato += '"soli_titulo":"' + tituloSoli + '",';
    dato += '"soli_responsable":"' + respon + '",';
    dato += '"soli_como_seHace":"' + comoSeHace + '",';
    dato += '"soli_visita_programada":"' + visitaProgramada + '",';

    dato += '"soli_fecha_visita":"' + fechaVisita + '",';

    dato += '"fk_id_status":"' + statusSolicitud + '"}';

    var datos = new FormData();
    datos.append("InsertarSoli", dato);

    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta != "") {
          swal({
            type: "success",
            title: "¡Datos registrados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          document.getElementById('GetEmpresas_EnSolicitud').getElementsByTagName('option')[0].selected = 'selected';
          //$("#GetEmpresas_EnSolicitud").val("0");
          document.getElementById('_SelectContacto').getElementsByTagName('option')[0].selected = 'selected';
          //$("#_SelectContacto").val("0");
          $("#txtTitulo_EnSolicitud").val("");
          document.getElementById('txtResponsable_EnSolicitud').getElementsByTagName('option')[0].selected = 'selected';
          //$("#txtResponsable_EnSolicitud").val("0");
          $("#txtComoSeHace_EnSolicitud").val("");
          $("#modalAgregarSolicitud").modal('hide');
          $("#fechaDeVisita").val("");
          $("#horaVisita").val();
          //$("#progamarVisita").removeClass("checked");
          //$("#progamarVisita").prop('checked', false);

          //$("#progamarVisita").prop("checked",false).trigger("change");
          $('#progamarVisita').prop('checked', false);
          sessionStorage._idSolicitud = respuesta;
          document.location = "detallesSolicitud";

        }
      }
    });
  }



}
function ValidateSesion() {
  $(".box-danger").addClass("collapsed-box");
  //document.getElementByClassName('bg-danger').disabled = true;
  //$(".bg-danger").disabled = true;
  $('.bg-danger').prop('disabled', true);
  $(".child").removeClass("fa-minus");
  $(".child").addClass("fa-plus");

  //inpus del primer Section
  $("._notasVisita").addClass('hidden');
  $("._tituloSoli").addClass('hidden');
  $("._FolioAsimex").addClass('hidden');
  //Pendiente de evaluar esta parte
  //var tr = $(".bg-danger").closest("i");
  //$(tr.childNodes).removeClass("fa-minus");
  //$(tr.childNodes).addClass("fa-plus");
}

function CargarDatos() {
  var id = $("#_Id_Solicitud").val();
//  if (sessionStorage._idSolicitud != undefined) {
    var datos = new FormData();
    datos.append("_idSolicitud", id);
    // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {

        $("#_Id_Solicitud").val(respuesta["id_solicitud"]);
        $("#txtIdSolicitud").val(respuesta["soli_folio"]);
        $("#txt_tituloSolicitud").val(respuesta["soli_titulo"]);
        $("#_txtResponsable").val(respuesta["us_nombre"]);
        $("#_txtEmpresa").val(respuesta["emp_nombre"]);
        $("#_txtContacto").val(respuesta["cont_nombre"]);

        $("#_btnGenerarDetallesSoli").addClass('hidden');
        if (respuesta["soli_visita_programada"] === "1") {
          //$("#progamarVisita").prop("checked", true);
          $('input[type="checkbox"][name="_progamarVisita"]').prop("checked", true).change();
          $("#_txtFechaDeCita").val(respuesta["soli_fecha_visita"]);
        } else {
          $('input[type="checkbox"][name="_progamarVisita"]').prop("checked", false).change();
          $("#_txtFechaDeCita").val("N/A");
        }

      }
    });
//  }
}

function cargarApardado(id) {
  if (id !== "") {
    $("._notasVisita").removeClass('hidden');
    $("._tituloSoli").removeClass('hidden');
    $("._FolioAsimex").removeClass('hidden');
    $("#_btnGenerarDetallesSoli").removeClass('hidden');
  } else {
    $("._notasVisita").addClass('hidden');
    $("._tituloSoli").addClass('hidden');
    $("._FolioAsimex").addClass('hidden');
    $("#_btnGenerarDetallesSoli").addClass('hidden');
  }
}

function guardarDetallesDeSolicitud() {
  var idSoli = $("#_Id_Solicitud").val();
  var notasDeVisita = $("#_txtNotasDeVisita").val();
  var folioAsimex = $("#txt_folioDeReferencia").val();
  var selectDep = $("#_selectDepartamento").val();

  var tiempoEntrega = $("#txt_tiempoEntrega").val();
  var cantidadPiezas = $("#txt_cantidadPiezas").val();
  var tipoCambio = $("#txt_tipoCambio_ventas").val();
  if (notasDeVisita == ""  || selectDep == "" || tiempoEntrega == "" || cantidadPiezas == "" || tipoCambio == "") {
    swal({
      type: "error",
      title: "¡Todos los campos marcados con  * son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  }else {
        var dato = '{"id_solicitud":"' + idSoli + '",';
        dato += '"soli_desc_notasDeVisita":"' + notasDeVisita + '",';
        dato += '"soli_folio_Asimex":"' + folioAsimex + '",';
        dato += '"soli_fechaEstimada_Entrega":"' + tiempoEntrega + '",';
        dato += '"soli_cantidad_piezas":"' + cantidadPiezas + '",';
        dato += '"soli_tipoCambio_ventas":"' + tipoCambio + '",';
        dato += '"fk_id_tipoServicio":"' + selectDep + '"}';

        var datos = new FormData();
        datos.append("InsertarDetallesSoli", dato);

        $.ajax({
          url: "ajax/solicitud.ajax.php",
          method: "POST",
          data: datos,
          cache: false,
          contentType: false,
          processData: false,
          dataType: "json",
          success: function(respuesta) {
            if (respuesta != "") {
              swal({
                type: "success",
                title: "¡Datos registrados correctamente!",
                showConfirmButton: true,
                confirmButtonText: "Cerrar"
              }).then(function(result) {
                if (result.value) {}
              });

              $(".box-danger").removeClass("collapsed-box");
              //document.getElementByClassName('bg-danger').disabled = true;
              //$(".bg-danger").disabled = true;
              $('.bg-danger').prop('disabled', false);

              $(".child").removeClass("fa-plus");
              $(".child").addClass("fa-minus");
              //inpus del primer Section
              $("#_notasVisita").removeClass('hidden');
              $("#_tituloSoli").removeClass('hidden');
              $("#_FolioAsimex").removeClass('hidden');
              $("#_botonesSolicitudDetalle").addClass('hidden');
              $("#_btnGenerarDetallesSoli").addClass('hidden')
              $("#_txtNotasDeVisita").prop("readonly", true);
              $("#txt_folioDeReferencia").prop("readonly", true);
              $("#txt_tiempoEntrega").prop("readonly", true);
              $("#txt_tipoCambio_ventas").prop("readonly", true);
              //$("#_selectDepartamento").prop("readonly", true);
              $("#txt_cantidadPiezas").prop("readonly", true);
              $("#txt_tituloSolicitud").prop("readonly", false);
              $("#_btnActualizarTituloSOLI").removeClass('hidden');
            }
          }
        });
  }
}
/*no se usa por el momento*/
function guardarPartidaMaterial() {
  var idSoli = $("#_Id_Solicitud").val();
  var unidadDeMedida = $("#nuevaUnidad_enMaterial").val();
  var descripcion = $("#nuevaDescripcion_enMaterial").val();
  var cantidad = $("#nuevaCantidadProducto_enMaterial").val();
  var importe = $("#nuevoPrecioProducto_enMaterial").val();
  var total = $("#nuevoTotalProducto_enMaterial").val();
  var dato = '{"fk_id_solicitud":"' + idSoli + '",';
  dato += '"mat_unidadDeMedida":"' + unidadDeMedida + '",';
  dato += '"mat_descripcion":"' + descripcion + '",';
  dato += '"mat_cantidad":"' + cantidad + '",';
  dato += '"mat_importe":"' + importe + '",';
  dato += '"mat_total":"' + total + '"}';
  var datos = new FormData();
  datos.append("InsertarMateriales", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Material registrado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {
            $("#_addMateriales").addClass('hidden');
            $("#BtnAddPartidasMaterial").removeClass('hidden');
          }
        });
        //Carga las partidas de los materiales
        printMateriales();
        totalDeSolicitud();
        //carga el total general de la solicitud
      } else {
        swal({
          type: "error",
          title: "¡Error al insertar material!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function printMateriales() {
  DestroyTableMateriales();
  var valor = 0;
  var idSoli = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("_GetMateriales", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalMateriales_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_material'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mat_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mat_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mat_descripcion'] + "</td>";
        if (respuesta[i]['moneda_descripcion'] == "MXN") {
          print += "<td>" + respuesta[i]['mat_importe'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['mat_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "<td>";
        print += "<div class='btn-group'>";
        print += "<a class='btn btn-warning EditMaterial' idSoli=" + respuesta[i]['id_material'] + "><i class='fa fa-pencil'></i></a>";
        print += "<a class='btn btn-danger DeleteMaterial' idDelete=" + respuesta[i]['id_material'] + "><i class='fa fa-times'></i></a>";
        print += "</div>";
        print += "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['mat_total']);
        TotalMateriales_USD = parseFloat(TotalMateriales_USD) + parseFloat(respuesta[i]['mat_total_dlls']);
      }
      var newTotalMaterial_USD = TotalMateriales_USD.toFixed(2);
      var newTotalMaterial_MXN = TotalMateriales.toFixed(2);
      $("#PrintPartidasMateriales").html(print);
      $("#_paratotales").removeClass("hidden");
      $("#_totalMaterial").html("$ " + newTotalMaterial_MXN);
      $("#_totalMaterial_USD").html("$ " + newTotalMaterial_USD);
      $("._FinMaterial").removeClass('hidden');
      TableMateriales();
    }
  })
}

function totalDeSolicitud() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("GetTotales", id);
  var totalIndExternoMX = 0;
  var totalIndExternoUSD = 0;
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#txtTotalFactura").val(respuesta["soli_total"]);
      $("#txtTotalSolicitud_usd").val(respuesta["soli_total_dlls"]);
      if (respuesta["soli_sumInd_materiales_mxn"] == "0" || respuesta["soli_sumInd_materiales_mxn"] == undefined) {
        $("#_IndividualMat_mxn").html("$ 0");
      }else {
        $("#_IndividualMat_mxn").html("$ " + respuesta["soli_sumInd_materiales_mxn"]);
      }
      if (respuesta["soli_sumInd_materiales_dlls"] == "0" || respuesta["soli_sumInd_materiales_dlls"] == undefined) {
        $("#_IndividualMat_usd").html("$ 0");
      }else {
        $("#_IndividualMat_usd").html("$ " + respuesta["soli_sumInd_materiales_dlls"]);
      }
      if (respuesta["soli_sumInd_manoDeObra_mxn"] == "0" || respuesta["soli_sumInd_manoDeObra_mxn"] == undefined) {
        $("#_IndividualMano_mxn").html("$ 0");
      }else {
        $("#_IndividualMano_mxn").html("$ " + respuesta["soli_sumInd_manoDeObra_mxn"]);
      }
      if (respuesta["soli_sumInd_manoDeObra_dlls"] == "0" || respuesta["soli_sumInd_manoDeObra_dlls"] == undefined) {
        $("#_IndividualMano_usd").html("$ 0");
      }else {
        $("#_IndividualMano_usd").html("$ " + respuesta["soli_sumInd_manoDeObra_dlls"]);
      }
      if (respuesta["soli_sumInd_hrsUnitarias"] == "0" || respuesta["soli_sumInd_hrsUnitarias"] == undefined) {
        $("#_IndividualHrs_mano").html("$ 0");
      }else {
          $("#_IndividualHrs_mano").html(respuesta["soli_sumInd_hrsUnitarias"] + " Hrs");

      }
      if (respuesta["soli_sumInd_indirectos_mxn"] == "0" || respuesta["soli_sumInd_indirectos_mxn"] == undefined) {
        $("#_IndividualInd_mxn").html("$ 0");
      }else {
          $("#_IndividualInd_mxn").html("$ " + respuesta["soli_sumInd_indirectos_mxn"]);
      }
      if (respuesta["soli_sumInd_indirectos_dlls"] == "0" || respuesta["soli_sumInd_indirectos_dlls"] == undefined) {
        $("#_IndividualInd_usd").html("$ 0");
      }else{
          $("#_IndividualInd_usd").html("$ " + respuesta["soli_sumInd_indirectos_dlls"]);
      }

      if (respuesta["soli_sumInd_externos_mxn"] == "0" || respuesta["soli_sumInd_externos_mxn"] == undefined) {
        $("#_IndividualExt_mxn").html("$ 0");
      }else {
          $("#_IndividualExt_mxn").html("$ " + respuesta["soli_sumInd_externos_mxn"]);
      }
      if (respuesta["soli_sumInd_externos_dlls"] == "0" || respuesta["soli_sumInd_externos_dlls"] == undefined) {
        $("#_IndividualExt_usd").html("$ 0");
      }else{
          $("#_IndividualExt_usd").html("$ " + respuesta["soli_sumInd_externos_dlls"]);
      }
    }
  });
}

/*=============================================
  GET INFORMACION DE PRODUCTO PARA EDITAR
=============================================*/
function GetDatosDeProducto(idPartida) {
  var datos = new FormData();
  datos.append("id_material", idPartida);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#_Id_Solicitud").val(respuesta["id_solicitud"]);
      $("#_Id_Material").val(respuesta["id_material"]);
      $("#nuevaUnidad_enMaterial").val(respuesta["mat_unidadDeMedida"]);
      $("#nuevaDescripcion_enMaterial").val(respuesta["mat_descripcion"]);
      $("#nuevaCantidadProducto_enMaterial").val(respuesta["mat_cantidad"]);
      if (respuesta["fk_tipoMoneda"] == 1) {
        $("#nuevoPrecioProducto_enMaterial").val(respuesta["mat_importe"]);
        $("#nuevoTotalProducto_enMaterial").val(respuesta["mat_total"]);
      }else {
        $("#nuevoPrecioProducto_enMaterial").val(respuesta["mat_importe_dlls"]);
        $("#nuevoTotalProducto_enMaterial").val(respuesta["mat_total_dlls"]);
      }
      $("#tipoMoneda_materiales").val(respuesta["fk_tipoMoneda"]);


    }
  });
}

function InsertOrUpdateMaterial_Solicitud() {
  //recibimos los datos del html
  var idSoli = $("#_Id_Solicitud").val();
  var unidadDeMedida = $("#nuevaUnidad_enMaterial").val();
  var descripcion = $("#nuevaDescripcion_enMaterial").val();
  var cantidad = $("#nuevaCantidadProducto_enMaterial").val();
  //========================================================
  var importe = $("#nuevoPrecioProducto_enMaterial").val();
  var total = $("#nuevoTotalProducto_enMaterial").val();
  //======================================================
  var tipoMoneda = $("#tipoMoneda_materiales").val();
  var cantidadPiezas = $("#txt_cantidadPiezas").val();

  var importeChange;
  var totalChange;
  var _idMaterial = $("#_Id_Material").val();
  if (unidadDeMedida == "" || descripcion == "" || cantidad == "" || importe == "" || total == "" || tipoMoneda == "") {
    swal({
      type: "error",
      title: "¡Todos los campos son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  }else {
    if (_idMaterial == "") {
      _idMaterial = 0;
    }
    var dato = '{"fk_id_solicitud":"' + idSoli + '",';
    dato += '"mat_unidadDeMedida":"' + unidadDeMedida + '",';
    dato += '"mat_descripcion":"' + descripcion + '",';
    dato += '"mat_cantidad":"' + cantidad + '",';
    //El tipo de moneda 1 es igual a MXN
    if (tipoMoneda == 1) {
      var tipoCambio = $("#txt_tipoCambio_ventas").val();
      importeChange = convierteAUSD(Number(importe), Number(tipoCambio));
      totalChange = convierteAUSD(Number(total),Number(tipoCambio));

      dato += '"mat_importe":"' + importe + '",';
      dato += '"mat_total":"' + total + '",';
      dato += '"mat_importe_dlls":"' + importeChange + '",';
      dato += '"mat_total_dlls":"' + totalChange + '",';
    }else {
      var tipoCambio = $("#txt_tipoCambio_ventas").val();
      importeChange = convierteAMXN(Number(importe), Number(tipoCambio));
      totalChange = convierteAMXN(Number(total),Number(tipoCambio));

      dato += '"mat_importe":"' + importeChange + '",';
      dato += '"mat_total":"' + totalChange + '",';
      dato += '"mat_importe_dlls":"' + importe + '",';
      dato += '"mat_total_dlls":"' + total + '",';
    }
    dato += '"soli_cantidad_piezas":"' + cantidadPiezas + '",';
    dato += '"fk_tipoMoneda":"' + tipoMoneda + '",';
    dato += '"id_material":"' + _idMaterial + '"}';


    var datos = new FormData();
    datos.append("InsertarMateriales", dato);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "insert") {
          swal({
            type: "success",
            title: "¡Material registrado correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addMateriales").addClass('hidden');
          $("#BtnAddPartidasMaterial").removeClass('hidden');
          //Carga las partidas de los materiales
          printMateriales();
          //carga el total general de la solicitud
          totalDeSolicitud();
        } else if (respuesta == "EditOK") {
          swal({
            type: "success",
            title: "¡Material actualizada correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addMateriales").addClass('hidden');
          $("#BtnAddPartidasMaterial").removeClass('hidden');
          //Carga las partidas de los materiales
          printMateriales();
          //carga el total general de la solicitud
          totalDeSolicitud();
        } else {
          swal({
            type: "error",
            title: "¡Error al realizar petición!" + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }

    });
  }
}
function convierteAUSD(monto,costoDlls){

    var newMonto = monto.toFixed(2);
    var newCostoDlls = costoDlls.toFixed(2);
    var resultado  = newMonto / newCostoDlls;
    return resultado;

}
function convierteAMXN(montoMX, costoDlls_){
  var newMonto =  montoMX.toFixed(2);
  var newCostoDlls = costoDlls_.toFixed(2);

  var resultado = newMonto * newCostoDlls;
  return resultado;
}

function limpiarCajas_Solicitud() {
  $("#nuevaUnidad_enMaterial").val("");
  $("#nuevaDescripcion_enMaterial").val("");
  $("#nuevaCantidadProducto_enMaterial").val("");
  $("#nuevoPrecioProducto_enMaterial").val("");
  $("#nuevoTotalProducto_enMaterial").val("");
  $("#_Id_Material").val("");
}

function limpiarCajasDeManoDeObra() {
  $("#nuevaUnidad_enManoDeObra").val("");
  $("#nuevaDescripcion_enManoDeObra").val("");
  $("#nuevaCantidadProducto_enManoDeObra").val("");
  $("#nuevoPrecioProducto_enManoDeObra").val("");
  $("#nuevoTotalProducto_enManoDeObra").val("");
  $("#_Id_ManoDeObra").val("");
}

function limpiarCajasDeIndirectos() {
  $("#nuevaUnidad_enIndirectos").val("");
  $("#nuevaDescripcion_enIndirectos").val("");
  $("#nuevaCantidadProducto_enIndirectos").val("");
  $("#nuevoPrecioProducto_enIndirectos").val("");
  $("#nuevoTotalProducto_enIndirectos").val("");
  $("#_Id_Indirectos").val("");
}

function limpiarCajasConceptos() {
  $("#nuevaUnidad_EnConceptos").val("");
  $("#nuevaDescripcion_EnConceptos").val("");
  $("#nuevaCantidadProducto_EnConceptos").val("");
  $("#nuevoPrecioProducto_EnConceptos").val("");
  $("#nuevoTotalProducto_EnConceptos").val("");
  $("#_Id_Concepto").val("");
}

function limpiarCajasDeExternos() {
  $("#nuevaUnidad_enExternos").val("");
  $("#nuevaDescripcion_enExternos").val("");
  $("#nuevaCantidadProducto_enExternos").val("");
  $("#nuevoPrecioProducto_enExternos").val("");
  $("#nuevoTotalProducto_enExternos").val("");
  $("#_Id_Externos").val("");
}

function EliminarMaterial(idEliminar) {
  var id = $("#_Id_Solicitud").val();
  var cantidad = $("#txt_cantidadPiezas").val();

  var dato = '{"id_solicitud":"' + id + '",';
  dato += '"soli_cantidad_piezas":"' + cantidad + '",';
  dato += '"idMaterial":"' + idEliminar + '"}';
  var datos = new FormData();
  datos.append("idMaterialAEliminar", dato);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Partida eliminada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
        //Carga las partidas de los materiales
        printMateriales();
        //carga el total general de la solicitud
        totalDeSolicitud();
      } else {
        swal({
          type: "error",
          title: "error al intentar eliminada!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
      }

    }

  })
}


function FinApartadoMateriales() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("FinMateriales", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado Guardado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__Materiales").addClass("collapsed-box");
        $(".__Materiales").removeClass("box-danger");
        $(".__Materiales").addClass("box-success box-solid");

        $("#BtnAddPartidasMaterial").addClass('hidden');
        $("._FinMaterial").addClass('hidden');
        $(".EditMaterial").addClass('disabled');
        $(".DeleteMaterial").addClass('disabled');

        $("._childMateriales").removeClass("fa-minus");
        $("._childMateriales").addClass("fa-plus");
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar finalizar apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}
/*==============================================================
=====================MANO DE OBRA=================================
===================================================================*/
function InsertOrUpdateManoDeObra_Solicitud() {
  //recibimos los datos del html
  var idSoli = $("#_Id_Solicitud").val();
  var unidadDeMedida = $("#nuevaUnidad_enManoDeObra").val();
  var descripcion = $("#nuevaDescripcion_enManoDeObra").val();
  var cantidad = $("#nuevaCantidadProducto_enManoDeObra").val();
  //========================================================
  var importe = $("#nuevoPrecioProducto_enManoDeObra").val();
  var total = $("#nuevoTotalProducto_enManoDeObra").val();
  //========================================================
  var tipoMoneda = $("#tipoMoneda_manoDeObra").val();
  var cantidadPiezas = $("#txt_cantidadPiezas").val();

  var importeChange;
  var totalChange;
  var _idManoDeObra = $("#_Id_ManoDeObra").val();
  //Validar campos del formulario
  if (unidadDeMedida == "" || descripcion == "" || cantidad == "" || importe == "" || total == "" || tipoMoneda == "") {
    swal({
      type: "error",
      title: "¡Todos los campos son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  }//Insertar partida de mano de obra
  else {
    if (_idManoDeObra == "") {
      _idManoDeObra = 0;
    }
      var dato = '{"fk_id_solicitud":"' + idSoli + '",';
      dato += '"mano_unidadDeMedida":"' + unidadDeMedida + '",';
      dato += '"mano_descripcion":"' + descripcion + '",';
      dato += '"mano_cantidad":"' + cantidad + '",';
    //El tipo de moneda 1 es igual a MXN
     if (tipoMoneda == 1) {
       var tipoCambio = $("#txt_tipoCambio_ventas").val();
       importeChange = convierteAUSD(Number(importe), Number(tipoCambio));
       totalChange = convierteAUSD(Number(total),Number(tipoCambio));

       dato += '"mano_importe":"' + importe + '",';
       dato += '"mano_total":"' + total + '",';
       dato += '"mano_importe_dlls":"' + importeChange + '",';
       dato += '"mano_total_dlls":"' + totalChange + '",';
     }else {
       var tipoCambio = $("#txt_tipoCambio_ventas").val();
       importeChange = convierteAMXN(Number(importe), Number(tipoCambio));
       totalChange = convierteAMXN(Number(total),Number(tipoCambio));

       dato += '"mano_importe":"' + importeChange + '",';
       dato += '"mano_total":"' + totalChange + '",';
       dato += '"mano_importe_dlls":"' + importe + '",';
       dato += '"mano_total_dlls":"' + total + '",';
     }
     dato += '"soli_cantidad_piezas":"' + cantidadPiezas + '",';
     dato += '"fk_tipoMoneda":"' + tipoMoneda + '",';
     dato += '"id_mano_de_obra":"' + _idManoDeObra + '"}';
     var datos = new FormData();
    datos.append("InsertarManoDeObra", dato);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "insert") {
          swal({
            type: "success",
            title: "¡Datos registrados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addManoDeObra").addClass('hidden');
          $("#BtnAddPartidasManoDeObra").removeClass('hidden');
          //Carga las partidas de los materiales
          printManoDeObra();
          //carga el total general de la solicitud
          totalDeSolicitud();
        } else if (respuesta == "EditOK") {
          swal({
            type: "success",
            title: "¡Datos actualizados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addManoDeObra").addClass('hidden');
          $("#BtnAddPartidasManoDeObra").removeClass('hidden');
          //Carga las partidas de los materiales
          printManoDeObra();
          //carga el total general de la solicitud
          totalDeSolicitud();
        } else {
          swal({
            type: "error",
            title: "¡Error al realizar petición!" + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }

    });
  }

}

function printManoDeObra() {
  DestroyTableManoDeObra();
  var valor = 0;
  var idSoli = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("_GetManoDeObra", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalManoDeObra = 0;
      var totalManoDeObra_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_mano_de_obra'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mano_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mano_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mano_descripcion'] + "</td>";

        if (respuesta[i]['moneda_descripcion'] == "MXN") {
          print += "<td>" + respuesta[i]['mano_importe'] + "</td>";
          print += "<td>" + respuesta[i]['mano_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['mano_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['mano_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";

        print += "<td>";
        print += "<div class='btn-group'>";
        print += "<a class='btn btn-warning EditManoDeObra' idSoli=" + respuesta[i]['id_mano_de_obra'] + "><i class='fa fa-pencil'></i></a>";
        print += "<a class='btn btn-danger DeleteManoDeObra' idDelete=" + respuesta[i]['id_mano_de_obra'] + "><i class='fa fa-times'></i></a>";
        print += "</div>";
        print += "</td>";
        print += "</tr>";
        TotalManoDeObra = parseFloat(TotalManoDeObra) + parseFloat(respuesta[i]['mano_total']);
        totalManoDeObra_USD = parseFloat(totalManoDeObra_USD) + parseFloat(respuesta[i]['mano_total_dlls']);

      }
      $("#PrintPartidasManoDeObra").html(print);
      $("#_paratotales_enManoDeObra").removeClass("hidden");
      $("#_totalManoDeObra").html("$ " + TotalManoDeObra);
      $("#_totalManoDeObra_USD").html("$ " + totalManoDeObra_USD);
      $("._FinManoDeObra").removeClass('hidden');
      TableManoDeObra();
    }
  })
}
//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTableManoDeObra() {
  var table = $('#tablaManoDeObra').DataTable();
  table.destroy();
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function TableManoDeObra() {
  $('#tablaManoDeObra').DataTable({
    "bPaginate": false,
    "bFilter": false,
    "bInfo": false,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}

/*=============================================
GET INFORMACION DE PRODUCTO PARA EDITAR
=============================================*/
function GetDatosDeManoDeObra(idPartida) {

  var datos = new FormData();
  datos.append("id_mano_de_obra", idPartida);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#_Id_Solicitud").val(respuesta["id_solicitud"]);
      $("#_Id_ManoDeObra").val(respuesta["id_mano_de_obra"]);
      $("#nuevaUnidad_enManoDeObra").val(respuesta["mano_unidadDeMedida"]);
      $("#nuevaDescripcion_enManoDeObra").val(respuesta["mano_descripcion"]);
      $("#nuevaCantidadProducto_enManoDeObra").val(respuesta["mano_cantidad"]);
      if (respuesta["fk_tipoMoneda"] == 1) {
        $("#nuevoPrecioProducto_enManoDeObra").val(respuesta["mano_importe"]);
        $("#nuevoTotalProducto_enManoDeObra").val(respuesta["mano_total"]);
      }else {
        $("#nuevoPrecioProducto_enManoDeObra").val(respuesta["mano_importe_dlls"]);
        $("#nuevoTotalProducto_enManoDeObra").val(respuesta["mano_total_dlls"]);
      }
      $("#tipoMoneda_manoDeObra").val(respuesta["fk_tipoMoneda"]);
    }
  });
}
/*=============================================
  ELIMINAR mano de obra
=============================================*/
function EliminarManoDeObra(idEliminar) {
  var id = $("#_Id_Solicitud").val();
  var cantidad = $("#txt_cantidadPiezas").val();

  var dato = '{"id_solicitud":"' + id + '",';
  dato += '"soli_cantidad_piezas":"' + cantidad + '",';
  dato += '"idManoDeObra":"' + idEliminar + '"}';
  var datos = new FormData();
  datos.append("idManoDeObraAEliminar", dato);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Partida eliminada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
        //Carga las partidas de los materiales
        printManoDeObra();
        //carga el total general de la solicitud
        totalDeSolicitud();
      } else {
        swal({
          type: "error",
          title: "error al intentar eliminada!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
      }

    }

  })
}
/*
function FinApartadoMateriales(){
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("FinMateriales", id);
      $.ajax({
        url: "ajax/solicitud.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta) {
            if (respuesta == "ok") {
              swal({
                type: "success",
                title: "¡Apartado Guardado correctamente!",
                showConfirmButton: true,
                confirmButtonText: "Cerrar"
              }).then(function(result){
                if(result.value){
                }
              });
              $(".__Materiales").addClass("collapsed-box");
              $(".__Materiales").removeClass("box-danger");
              $(".__Materiales").addClass("box-success box-solid");

              $("#BtnAddPartidasMaterial").addClass('hidden');
              $("._FinMaterial").addClass('hidden');
              $(".EditMaterial").addClass('disabled');
              $(".DeleteMaterial").addClass('disabled');

              $("._childMateriales").removeClass("fa-minus");
              $("._childMateriales").addClass("fa-plus");
          }
            else {
              swal({
                type: "error",
                title: "Error al intentar finalizar apartado" + respuesta,
                showConfirmButton: true,
                confirmButtonText: "Cerrar"
              }).then(function(result){
                if(result.value){
                }
              });
            }
        }
    });
}
*/
function FinApartadoManoDeObra() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("FinManoDeObra", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado Guardado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__ManoDeObra").addClass("collapsed-box");
        $(".__ManoDeObra").removeClass("box-danger");
        $(".__ManoDeObra").addClass("box-success box-solid");

        $("#BtnAddPartidasManoDeObra").addClass('hidden');
        $("._FinManoDeObra").addClass('hidden');
        $(".EditManoDeObra").addClass('disabled');
        $(".DeleteManoDeObra").addClass('disabled');

        $("._childManoDeObra").removeClass("fa-minus");
        $("._childManoDeObra").addClass("fa-plus");
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar finalizar apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

/*==============================================================
=====================INDIRECTOS =================================
===================================================================*/
function InsertOrUpdateIndirectos_Solicitud() {
  //recibimos los datos del html
  var idSoli = $("#_Id_Solicitud").val();
  var unidadDeMedida = $("#nuevaUnidad_enIndirectos").val();
  var descripcion = $("#nuevaDescripcion_enIndirectos").val();
  var cantidad = $("#nuevaCantidadProducto_enIndirectos").val();
  //========================================================
  var importe = $("#nuevoPrecioProducto_enIndirectos").val();
  var total = $("#nuevoTotalProducto_enIndirectos").val();
  //========================================================
  var tipoMoneda = $("#tipoMoneda_indirectos").val();
  var cantidadPiezas = $("#txt_cantidadPiezas").val();

  var importeChange;
  var totalChange;

  var _idIndirectos = $("#_Id_Indirectos").val();
  if (unidadDeMedida == "" || descripcion == "" || cantidad == "" || importe == "" || total == "" || tipoMoneda == "") {
    swal({
      type: "error",
      title: "¡Todos los campos son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  }else {

      if (_idIndirectos == "") {
        _idIndirectos = 0;
      }
      var dato = '{"fk_id_solicitud":"' + idSoli + '",';
      dato += '"ind_unidadDeMedida":"' + unidadDeMedida + '",';
      dato += '"ind_descripcion":"' + descripcion + '",';
      dato += '"ind_cantidad":"' + cantidad + '",';

      //El tipo de moneda 1 es igual a MXN
      if (tipoMoneda == 1) {
        var tipoCambio = $("#txt_tipoCambio_ventas").val();
        importeChange = convierteAUSD(Number(importe), Number(tipoCambio));
        totalChange = convierteAUSD(Number(total),Number(tipoCambio));

        dato += '"ind_importe":"' + importe + '",';
        dato += '"ind_total":"' + total + '",';
        dato += '"ind_importe_dlls":"' + importeChange + '",';
        dato += '"ind_total_dlls":"' + totalChange + '",';
      }else {
        var tipoCambio = $("#txt_tipoCambio_ventas").val();
        importeChange = convierteAMXN(Number(importe), Number(tipoCambio));
        totalChange = convierteAMXN(Number(total),Number(tipoCambio));

        dato += '"ind_importe":"' + importeChange + '",';
        dato += '"ind_total":"' + totalChange + '",';
        dato += '"ind_importe_dlls":"' + importe + '",';
        dato += '"ind_total_dlls":"' + total + '",';
      }
      dato += '"soli_cantidad_piezas":"' + cantidadPiezas + '",';
      dato += '"fk_tipoMoneda":"' + tipoMoneda + '",';
      dato += '"id_gasto_indirecto":"' + _idIndirectos + '"}';

      var datos = new FormData();
      datos.append("InsertarIndirectos", dato);
      $.ajax({
        url: "ajax/solicitud.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta) {
          if (respuesta == "insert") {
            swal({
              type: "success",
              title: "¡Datos registrados correctamente!",
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
            $("#_addIndirectos").addClass('hidden');
            $("#BtnAddPartidasIndirectos").removeClass('hidden');
            //Carga las partidas de los materiales
            printIndirectos();
            //carga el total general de la solicitud
            totalDeSolicitud();
          } else if (respuesta == "EditOK") {
            swal({
              type: "success",
              title: "¡Datos actualizados correctamente!",
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
            $("#_addIndirectos").addClass('hidden');
            $("#BtnAddPartidasIndirectos").removeClass('hidden');
            //Carga las partidas de los materiales
            printIndirectos();
            //carga el total general de la solicitud
            totalDeSolicitud();
          } else {
            swal({
              type: "error",
              title: "¡Error al realizar petición!" + respuesta,
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
          }
        }

      });
  }
}

function printIndirectos() {
  DestroyTableIndirectos();
  var valor = 0;
  var idSoli = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("_GetIndirectos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalManoDeObra = 0;
      var TotalIndirectos_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_indirecto'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ind_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ind_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ind_descripcion'] + "</td>";

        if (respuesta[i]['moneda_descripcion'] == "MXN") {
          print += "<td>" + respuesta[i]['ind_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ind_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "<td>";
        print += "<div class='btn-group'>";
        print += "<a class='btn btn-warning EditIndirectos' idSoli=" + respuesta[i]['id_gasto_indirecto'] + "><i class='fa fa-pencil'></i></a>";
        print += "<a class='btn btn-danger DeleteIndirectos' idDelete=" + respuesta[i]['id_gasto_indirecto'] + "><i class='fa fa-times'></i></a>";
        print += "</div>";
        print += "</td>";
        print += "</tr>";
        TotalManoDeObra = parseFloat(TotalManoDeObra) + parseFloat(respuesta[i]['ind_total']);
        TotalIndirectos_USD = parseFloat(TotalIndirectos_USD) + parseFloat(respuesta[i]['ind_total_dlls']);
      }
      newTotalIndirectos = TotalManoDeObra.toFixed(2);
      newTotalIndirectosUSD = TotalIndirectos_USD.toFixed(2);
      $("#PrintPartidasIndirectos").html(print);
      $("#_paratotales_enIndirectos").removeClass("hidden");
      $("#_totalIndirectos").html("$ " + newTotalIndirectos);
      $("#_totalIndirectos_USD").html("$ " + newTotalIndirectosUSD);
      $("._FinIndirectos").removeClass('hidden');
      TableIndirectos();
    }
  })
}
//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTableIndirectos() {
  var table = $('#tblGastosIndirectos').DataTable();
  table.destroy();
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function TableIndirectos() {
  $('#tblGastosIndirectos').DataTable({
    "bPaginate": false,
    "bFilter": false,
    "bInfo": false,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}

/*=============================================
  ELIMINAR mano de obra
=============================================*/
function EliminarIndirectos(idEliminar) {
  var id = $("#_Id_Solicitud").val();
  var cantidad = $("#txt_cantidadPiezas").val();
  var dato = '{"id_solicitud":"' + id + '",';
  dato += '"soli_cantidad_piezas":"' + cantidad + '",';
  dato += '"idIndirectos":"' + idEliminar + '"}';
  var datos = new FormData();
  datos.append("idIndirectos", dato);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Partida eliminada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
        //Carga las partidas de los materiales
        printIndirectos();
        //carga el total general de la solicitud
        totalDeSolicitud();
      } else {
        swal({
          type: "error",
          title: "error al intentar eliminada!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
      }

    }

  })
}
/*=============================================
GET INFORMACION DE PRODUCTO PARA EDITAR
=============================================*/
function GetDatosIndirectos(idPartida) {

  var datos = new FormData();
  datos.append("id_gasto_indirecto", idPartida);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#_Id_Solicitud").val(respuesta["id_solicitud"]);
      $("#_Id_Indirectos").val(respuesta["id_gasto_indirecto"]);
      $("#nuevaUnidad_enIndirectos").val(respuesta["ind_unidadDeMedida"]);
      $("#nuevaDescripcion_enIndirectos").val(respuesta["ind_descripcion"]);
      $("#nuevaCantidadProducto_enIndirectos").val(respuesta["ind_cantidad"]);
      if (respuesta["fk_tipoMoneda"] == 1) {
        $("#nuevoPrecioProducto_enIndirectos").val(respuesta["ind_importe"]);
        $("#nuevoTotalProducto_enIndirectos").val(respuesta["ind_total"]);
      }else {
        $("#nuevoPrecioProducto_enIndirectos").val(respuesta["ind_importe_dlls"]);
        $("#nuevoTotalProducto_enIndirectos").val(respuesta["ind_total_dlls"]);
      }
      $("#tipoMoneda_indirectos").val(respuesta["fk_tipoMoneda"]);
    }
  });
}

function FinApartadoIndirectos() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("FinIndirectos", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado Guardado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__Indirectos").addClass("collapsed-box");
        $(".__Indirectos").removeClass("box-danger");
        $(".__Indirectos").addClass("box-success box-solid");

        $("#BtnAddPartidasIndirectos").addClass('hidden');
        $("._FinIndirectos").addClass('hidden');
        $(".EditIndirectos").addClass('disabled');
        $(".DeleteIndirectos").addClass('disabled');

        $("._childIndirectos").removeClass("fa-minus");
        $("._childIndirectos").addClass("fa-plus");
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar finalizar apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}


/*=================================================================
   ====================EXTERNOS =================================
===================================================================*/
function InsertOrUpdateExternos_Solicitud() {
  //recibimos los datos del html
  var idSoli = $("#_Id_Solicitud").val();
  var unidadDeMedida = $("#nuevaUnidad_enExternos").val();
  var descripcion = $("#nuevaDescripcion_enExternos").val();
  var cantidad = $("#nuevaCantidadProducto_enExternos").val();
  //======================================================
  var importe = $("#nuevoPrecioProducto_enExternos").val();
  var total = $("#nuevoTotalProducto_enExternos").val();
  //======================================================
  var tipoMoneda = $("#tipoMoneda_externos").val();
  var cantidadPiezas = $("#txt_cantidadPiezas").val();
  var importeChange;
  var totalChange;
  var _idExternos = $("#_Id_Externos").val();


  if (unidadDeMedida == "" || descripcion == "" || cantidad == "" || importe == "" || total == "") {
      swal({
      type: "error",
      title: "¡Todos los campos son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
      }).then(function(result) {
      if (result.value) {}
      });
  }else {
    if (_idExternos == "") {
      _idExternos = 0;
    }
    var dato = '{"fk_id_solicitud":"' + idSoli + '",';
    dato += '"ext_unidadDeMedida":"' + unidadDeMedida + '",';
    dato += '"ext_descripcion":"' + descripcion + '",';
    dato += '"ext_cantidad":"' + cantidad + '",';

        //El tipo de moneda 1 es igual a MXN
    if (tipoMoneda == 1) {
      var tipoCambio = $("#txt_tipoCambio_ventas").val();
      importeChange = convierteAUSD(Number(importe), Number(tipoCambio));
      totalChange = convierteAUSD(Number(total),Number(tipoCambio));

      dato += '"ext_importe":"' + importe + '",';
      dato += '"ext_total":"' + total + '",';
      dato += '"ext_importe_dlls":"' + importeChange + '",';
      dato += '"ext_total_dlls":"' + totalChange + '",';
    }else {
      var tipoCambio = $("#txt_tipoCambio_ventas").val();
      importeChange = convierteAMXN(Number(importe), Number(tipoCambio));
      totalChange = convierteAMXN(Number(total),Number(tipoCambio));

      dato += '"ext_importe":"' + importeChange + '",';
      dato += '"ext_total":"' + totalChange + '",';
      dato += '"ext_importe_dlls":"' + importe + '",';
      dato += '"ext_total_dlls":"' + total + '",';
    }
    dato += '"soli_cantidad_piezas":"' + cantidadPiezas + '",';
    dato += '"fk_tipoMoneda":"' + tipoMoneda + '",';
    dato += '"id_gasto_externo":"' + _idExternos + '"}';

    var datos = new FormData();
    datos.append("InsertarExternos", dato);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "insert") {
          swal({
            type: "success",
            title: "¡Datos registrados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addExternos").addClass('hidden');
          $("#BtnAddPartidasExternos").removeClass('hidden');
          //Carga las partidas de los materiales
          printExternos();
          //carga el total general de la solicitud
          totalDeSolicitud();
        } else if (respuesta == "EditOK") {
          swal({
            type: "success",
            title: "¡Datos actualizados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addExternos").addClass('hidden');
          $("#BtnAddPartidasExternos").removeClass('hidden');
          //Carga las partidas de los materiales
          printExternos();
          //carga el total general de la solicitud
          totalDeSolicitud();
        } else {
          swal({
            type: "error",
            title: "¡Error al realizar petición!" + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }
    });
  }
}

function printExternos() {
  DestroyTableExternos();
  var valor = 0;
  var idSoli = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("_GetExternos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalManoDeObra = 0;
      var totalExternosUSD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_externo'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ext_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ext_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ext_descripcion'] + "</td>";
        if (respuesta[i]['moneda_descripcion'] == "MXN") {
          print += "<td>" + respuesta[i]['ext_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ext_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total_dlls'] + "</td>";
        }
          print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";

        print += "<td>";
        print += "<div class='btn-group'>";
        print += "<a class='btn btn-warning EditExternos' idSoli=" + respuesta[i]['id_gasto_externo'] + "><i class='fa fa-pencil'></i></a>";
        print += "<a class='btn btn-danger DeleteExternos' idDelete=" + respuesta[i]['id_gasto_externo'] + "><i class='fa fa-times'></i></a>";
        print += "</div>";
        print += "</td>";
        print += "</tr>";
        TotalManoDeObra = parseFloat(TotalManoDeObra) + parseFloat(respuesta[i]['ext_total']);
        totalExternosUSD = parseFloat(totalExternosUSD) + parseFloat(respuesta[i]['ext_total_dlls']);
      }
      newTotalExtMX = TotalManoDeObra.toFixed(2);
      newTotalExtUSD = totalExternosUSD.toFixed(2);
      $("#PrintPartidasExternos").html(print);
      $("#_paratotales_enExternos").removeClass("hidden");
      $("#_totalExternos").html("$ " + newTotalExtMX);

      $("#_totalExternos_USD").html("$ " + newTotalExtUSD);

      $("._FinExternos").removeClass('hidden');
      TableExternos();
    }
  })
}
//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTableExternos() {
  var table = $('#tblGastosExternos').DataTable();
  table.destroy();
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function TableExternos() {
  $('#tblGastosExternos').DataTable({
    "bPaginate": false,
    "bFilter": false,
    "bInfo": false,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}

/*=============================================
GET INFORMACION DE PRODUCTO PARA EDITAR
=============================================*/
function GetDatosExternos(idPartida) {

  var datos = new FormData();
  datos.append("id_gasto_externo", idPartida);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#_Id_Solicitud").val(respuesta["id_solicitud"]);
      $("#_Id_Externos").val(respuesta["id_gasto_externo"]);
      $("#nuevaUnidad_enExternos").val(respuesta["ext_unidadDeMedida"]);
      $("#nuevaDescripcion_enExternos").val(respuesta["ext_descripcion"]);
      $("#nuevaCantidadProducto_enExternos").val(respuesta["ext_cantidad"]);
      $("#nuevoPrecioProducto_enExternos").val(respuesta["ext_importe"]);
      $("#nuevoTotalProducto_enExternos").val(respuesta["ext_total"]);
    }
  });
}
/*=============================================
  ELIMINAR PARTIDAS DE EXTERNOS
=============================================*/
function EliminarExternos(idEliminar) {
  var id = $("#_Id_Solicitud").val();
  var cantidad = $("#txt_cantidadPiezas").val();

  var dato = '{"id_solicitud":"' + id + '",';
  dato += '"soli_cantidad_piezas":"' + cantidad + '",';
  dato += '"idExternos":"' + idEliminar + '"}';
  var datos = new FormData();
  datos.append("idExternos", dato);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Partida eliminada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
        //Carga las partidas de los materiales
        printExternos();
        //carga el total general de la solicitud
        totalDeSolicitud();
      } else {
        swal({
          type: "error",
          title: "error al intentar eliminada!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
      }

    }

  })
}

function FinApartadoExternos() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("FinExternos", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado Guardado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__Externos").addClass("collapsed-box");
        $(".__Externos").removeClass("box-danger");
        $(".__Externos").addClass("box-success box-solid");

        $("#BtnAddPartidasExternos").addClass('hidden');
        $("._FinExternos").addClass('hidden');
        $(".EditExternos").addClass('disabled');
        $(".DeleteExternos").addClass('disabled');

        $("._childExternos").removeClass("fa-minus");
        $("._childExternos").addClass("fa-plus");
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar finalizar apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function ReactivarApartadoMateriales() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("ReactivaMateriales", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado ativado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__Materiales").removeClass("collapsed-box");
        $(".__Materiales").addClass("box-danger");
        $(".__Materiales").removeClass("box-success box-solid");
        $("#BtnAddPartidasMaterial").removeClass('hidden');
        $("._FinMaterial").removeClass('hidden');
        $(".EditMaterial").removeClass('disabled');
        $(".DeleteMaterial").removeClass('disabled');
        $("._childMateriales").addClass("fa-minus");
        $("._childMateriales").removeClass("fa-plus");
        $("._IniciaMaterial").addClass('hidden');
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar reactivar el apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function ReactivarApartadoManoDeObra() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("ReactivaManoDeObra", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado ativado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__ManoDeObra").removeClass("collapsed-box");
        $(".__ManoDeObra").addClass("box-danger");
        $(".__ManoDeObra").removeClass("box-success box-solid");
        $("#BtnAddPartidasManoDeObra").removeClass('hidden');
        $("._FinManoDeObra").removeClass('hidden');
        $(".EditManoDeObra").removeClass('disabled');
        $(".DeleteManoDeObra").removeClass('disabled');
        $("._childManoDeObra").addClass("fa-minus");
        $("._childManoDeObra").removeClass("fa-plus");
        $("._IniciaManoDeObra").addClass('hidden');
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar reactivar el apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function ReactivarApartadoIndirectos() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("ReactivaIndirectos", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado ativado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__Indirectos").removeClass("collapsed-box");
        $(".__Indirectos").addClass("box-danger");
        $(".__Indirectos").removeClass("box-success box-solid");
        $("#BtnAddPartidasIndirectos").removeClass('hidden');
        $("._FinIndirectos").removeClass('hidden');
        $(".EditIndirectos").removeClass('disabled');
        $(".DeleteIndirectos").removeClass('disabled');
        $("._childIndirectos").addClass("fa-minus");
        $("._childIndirectos").removeClass("fa-plus");
        $("._IniciaIndirectos").addClass('hidden');
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar reactivar el apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function ReactivarApartadoExternos() {
  var id = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("ReactivaExternos", id);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Apartado ativado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        $(".__Externos").removeClass("collapsed-box");
        $(".__Externos").addClass("box-danger");
        $(".__Externos").removeClass("box-success box-solid");
        $("#BtnAddPartidasExternos").removeClass('hidden');
        $("._FinExternos").removeClass('hidden');
        $(".EditExternos").removeClass('disabled');
        $(".DeleteExternos").removeClass('disabled');
        $("._childExternos").addClass("fa-minus");
        $("._childExternos").removeClass("fa-plus");
        $("._IniciaExternos").addClass('hidden');
        VerificaElStatusDeApartados();
      } else {
        swal({
          type: "error",
          title: "Error al intentar reactivar el apartado" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function VerificaElStatusDeApartados() {

  var id = $("#_Id_Solicitud").val();
  if (id !== "") {
    var datos = new FormData();
    datos.append("_Finalizar", id);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta['totales'] == "4") {
          $("._finalizar").removeClass('hidden');
        } else {
          $("._finalizar").addClass('hidden');
        }

      }
    });
  }

}

function FinalizarSolicitud() {
  var id = $("#_Id_Solicitud").val();
  if (id !== "") {
    var datos = new FormData();
    datos.append("_FinalizarSolicitud", id);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "ok") {
          document.location = "solicitudes";
          $("_Id_Solicitud").val("");
          sessionStorage.clear();
        } else {
          swal({
            type: "error",
            title: "Error al intentar finalizar la solicitud : " + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }
    });
  }
}
function RechazarSolicitudCoordinador() {
  var id = $("#_Id_Solicitud").val();
  if (id !== "") {
    var datos = new FormData();
    datos.append("_RechazarSolicitud", id);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "ok") {
          document.location = "solicitudes";
          $("_Id_Solicitud").val("");
          sessionStorage.clear();
        } else {
          swal({
            type: "error",
            title: "Error al intentar finalizar la solicitud : " + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }
    });
  }
}
function AprobarSolicitudCoordinador() {
  var id = $("#_Id_Solicitud").val();
  if (id !== "") {
    var datos = new FormData();
    datos.append("_AprobarSolicitud", id);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "ok") {
          swal({
            type: "success",
            title: "Solicitud Aprobada Correctamente",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
            document.location = "solicitudes";
            $("_Id_Solicitud").val("");
            sessionStorage.clear();
          });

        } else {
          swal({
            type: "error",
            title: "Error al intentar finalizar la solicitud : " + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }
    });
  }
}

function CargarDatosParaEdit() {
  var id = $("#_Id_Solicitud").val();
  //if (sessionStorage._idSolicitudEdit != undefined) {
    var datos = new FormData();
    datos.append("_idSolicitud", id);
    // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {

        $("#_Id_Solicitud").val(respuesta["id_solicitud"]);
        $("#txtIdSolicitud").val(respuesta["soli_folio"]);
        $("#txt_tituloSolicitud").val(respuesta["soli_titulo"]);
        $("#_txtResponsable").val(respuesta["us_nombre"]);
        $("#_txtEmpresa").val(respuesta["emp_nombre"]);
        $("#_txtContacto").val(respuesta["cont_nombre"]);
        $("#_txtNotasDeVisita").val(respuesta["soli_desc_notasDeVisita"]);
        $("#txt_tiempoEntrega").val(respuesta["soli_fechaEstimada_Entrega"]);

        $("#txt_cantidadPiezas").val(respuesta["soli_cantidad_piezas"]);
        $("#txt_tipoCambio_ventas").val(respuesta["soli_tipoCambio_ventas"]);

        if (respuesta["soli_folio_Asimex"] !== "") {
          $("#txt_folioDeReferencia").val(respuesta["soli_folio_Asimex"]);
        } else {
          $("#txt_folioDeReferencia").val("N/A");
        }
        if (respuesta["fk_id_tipoServicio"] !== null && respuesta["fk_id_tipoServicio"] !== "" && respuesta["fk_id_tipoServicio"] !== undefined) {
          $("#_selectDepartamento").val(respuesta["fk_id_tipoServicio"]);
          $("#_btnGenerarDetallesSoli").addClass('hidden');
          $("._notasVisita").removeClass('hidden');
          $("._FolioAsimex").removeClass('hidden');
          $("._tituloSoli").removeClass('hidden');
          $(".btn-sm").prop('disabled', false);
          $("#_txtNotasDeVisita").prop("readonly", true);
          $("#txt_folioDeReferencia").prop("readonly", true);
          $("#txt_tiempoEntrega").prop("readonly", true);
          $("#txt_tipoCambio_ventas").prop("readonly", true);
          $("#_selectDepartamento").prop("readonly", true);
          $("#txt_cantidadPiezas").prop("readonly", true);
          $("#txt_tituloSolicitud").prop("readonly", false);
          $("#_btnActualizarTituloSOLI").removeClass('hidden');
        } else {
          $("#_selectDepartamento").val("0");
          cargarApardado($("#_selectDepartamento").val());
          $(".box-danger").addClass("collapsed-box");
          //document.getElementByClassName('bg-danger').disabled = true;
          //$(".bg-danger").disabled = true;
          $('.bg-danger').prop('disabled', true);
          $(".child").removeClass("fa-minus");
          $(".child").addClass("fa-plus");

          //inpus del primer Section
          $("._notasVisita").addClass('hidden');
          $("._tituloSoli").addClass('hidden');
          $("._FolioAsimex").addClass('hidden');
        }


        //$("#_btnGenerarDetallesSoli").addClass('hidden');
        if (respuesta["soli_visita_programada"] === "1") {
          //$("#progamarVisita").prop("checked", true);
          $('input[type="checkbox"][name="_progamarVisita"]').prop("checked", true).change();
          $("#_txtFechaDeCita").val(respuesta["soli_fecha_visita"]);
        } else {
          $('input[type="checkbox"][name="_progamarVisita"]').prop("checked", false).change();
          $("#_txtFechaDeCita").val("N/A");
        }
      }
    });
//  }
}

function VerificaStatusDeLaSolicitus() {
  var id = $("#_Id_Solicitud").val();
  if (id !== "") {
    var datos = new FormData();
    datos.append("_Finalizar", id);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        var rol = $("#_us_rol_solicitud").val();

        if (respuesta['totales'] == "4") {
          FinApartadoMaterialesSinMsj();
          FinApartadoManoDeObraSinMsj();
          FinApartadoIndirectosSinMsj();
          FinApartadoExternosSinMsj();
          $("._FinMaterial").addClass('hidden');
          $("._FinManoDeObra").addClass('hidden');
          $("._FinIndirectos").addClass('hidden');
          $("._FinExternos").addClass('hidden');
          $("._finalizar ").removeClass('hidden');
          $("#_btnGenerarDetallesSoli").addClass('hidden');
        }else {
          if (respuesta['soli_termina_materiales'] == null || respuesta['soli_termina_materiales'] == 0) {
            ReactivarApartadoMaterialesSinMsj();

          } else {
            FinApartadoMaterialesSinMsj();

          }
          if (respuesta['soli_termina_manoDeObra'] == null || respuesta['soli_termina_manoDeObra'] == 0) {
            ReactivarApartadoManoDeObraSinMsj();

          } else {
            FinApartadoManoDeObraSinMsj();

          }
          if (respuesta['soli_termina_indirectos'] == null || respuesta['soli_termina_indirectos'] == 0) {
            ReactivarApartadoIndirectosSinMsj();

          } else {
            FinApartadoIndirectosSinMsj();

          }
          if (respuesta['soli_termina_externos'] == null || respuesta['soli_termina_externos'] == 0) {
            ReactivarApartadoExternosSinMsj();

          } else {
            FinApartadoExternosSinMsj();

          }
        }
        /*Hacer validacion para poder veirificar cuando la solicitud tenga el status de Por Aprobacion de Estimacion
       y la suma del total de 'respuesta['totales']' sea < a '4' */
        if (respuesta['totales'] !== "4" && respuesta['fk_id_status'] == "10" && rol == "3") {
          $("._cancelar").removeClass('hidden');
          $("._finalizar").addClass('hidden');
        }else if (respuesta['totales'] == "4" && respuesta['fk_id_status'] == "10" && rol == "3") {
          $("._cancelar").removeClass('hidden');
          $("._finalizar").addClass('hidden');
          $("._divAprobar").removeClass('hidden');
        }
      }
    });
  }
}
function FinApartadoMaterialesSinMsj() {
  $(".__Materiales").addClass("collapsed-box");
  $(".__Materiales").removeClass("box-danger");
  $(".__Materiales").addClass("box-success box-solid");
  $("#BtnAddPartidasMaterial").addClass('hidden');
  $("._FinMaterial").addClass('hidden');
  $(".EditMaterial").addClass('disabled');
  $(".DeleteMaterial").addClass('disabled');
  $("._childMateriales").removeClass("fa-minus");
  $("._childMateriales").addClass("fa-plus");
  $("._IniciaMaterial").removeClass('hidden');
}
function FinApartadoManoDeObraSinMsj() {
  $(".__ManoDeObra").addClass("collapsed-box");
  $(".__ManoDeObra").removeClass("box-danger");
  $(".__ManoDeObra").addClass("box-success box-solid");
  $("#BtnAddPartidasManoDeObra").addClass('hidden');
  $("._FinManoDeObra").addClass('hidden');
  $(".EditManoDeObra").addClass('disabled');
  $(".DeleteManoDeObra").addClass('disabled');
  $("._childManoDeObra").removeClass("fa-minus");
  $("._childManoDeObra").addClass("fa-plus");
  $("._IniciaManoDeObra").removeClass('hidden');
}
function FinApartadoIndirectosSinMsj() {
  $(".__Indirectos").addClass("collapsed-box");
  $(".__Indirectos").removeClass("box-danger");
  $(".__Indirectos").addClass("box-success box-solid");
  $("#BtnAddPartidasIndirectos").addClass('hidden');
  $("._FinIndirectos").addClass('hidden');
  $(".EditIndirectos").addClass('disabled');
  $(".DeleteIndirectos").addClass('disabled');
  $("._childIndirectos").removeClass("fa-minus");
  $("._childIndirectos").addClass("fa-plus");

  $("._IniciaIndirectos").removeClass('hidden');


}

function FinApartadoExternosSinMsj() {

  $(".__Externos").addClass("collapsed-box");
  $(".__Externos").removeClass("box-danger");
  $(".__Externos").addClass("box-success box-solid");

  $("#BtnAddPartidasExternos").addClass('hidden');
  $("._FinExternos").addClass('hidden');
  $(".EditExternos").addClass('disabled');
  $(".DeleteExternos").addClass('disabled');

  $("._childExternos").removeClass("fa-minus");
  $("._childExternos").addClass("fa-plus");

  $("._IniciaExternos").removeClass('hidden');

}

function ReactivarApartadoMaterialesSinMsj() {

  $(".__Materiales").removeClass("collapsed-box");
  $(".__Materiales").addClass("box-danger");
  $(".__Materiales").removeClass("box-success box-solid");
  $("#BtnAddPartidasMaterial").removeClass('hidden');
  $("._FinMaterial").removeClass('hidden');
  $(".EditMaterial").removeClass('disabled');
  $(".DeleteMaterial").removeClass('disabled');
  $("._childMateriales").addClass("fa-minus");
  $("._childMateriales").removeClass("fa-plus");
  $("._IniciaMaterial").addClass('hidden');

  $("._FinMaterial").removeClass('hidden');

}

function ReactivarApartadoManoDeObraSinMsj() {

  $(".__ManoDeObra").removeClass("collapsed-box");
  $(".__ManoDeObra").addClass("box-danger");
  $(".__ManoDeObra").removeClass("box-success box-solid");
  $("#BtnAddPartidasManoDeObra").removeClass('hidden');
  $("._FinManoDeObra").removeClass('hidden');
  $(".EditManoDeObra").removeClass('disabled');
  $(".DeleteManoDeObra").removeClass('disabled');
  $("._childManoDeObra").addClass("fa-minus");
  $("._childManoDeObra").removeClass("fa-plus");
  $("._IniciaManoDeObra").addClass('hidden');

  $("._FinManoDeObra").removeClass('hidden');
}

function ReactivarApartadoIndirectosSinMsj() {

  $(".__Indirectos").removeClass("collapsed-box");
  $(".__Indirectos").addClass("box-danger");
  $(".__Indirectos").removeClass("box-success box-solid");
  $("#BtnAddPartidasIndirectos").removeClass('hidden');
  $("._FinIndirectos").removeClass('hidden');
  $(".EditIndirectos").removeClass('disabled');
  $(".DeleteIndirectos").removeClass('disabled');
  $("._childIndirectos").addClass("fa-minus");
  $("._childIndirectos").removeClass("fa-plus");
  $("._IniciaIndirectos").addClass('hidden');

  $("._FinIndirectos").removeClass('hidden');

}

function ReactivarApartadoExternosSinMsj() {

  $(".__Externos").removeClass("collapsed-box");
  $(".__Externos").addClass("box-danger");
  $(".__Externos").removeClass("box-success box-solid");
  $("#BtnAddPartidasExternos").removeClass('hidden');
  $("._FinExternos").removeClass('hidden');
  $(".EditExternos").removeClass('disabled');
  $(".DeleteExternos").removeClass('disabled');
  $("._childExternos").addClass("fa-minus");
  $("._childExternos").removeClass("fa-plus");
  $("._IniciaExternos").addClass('hidden');

  $("._FinExternos").removeClass('hidden');
}

/*============================================================
    APARTADO PARA LA CAPTURA DE CONCEPTOS
===============================================================*/
function SaveTiempoEntregaAdmin() {
    var id = $("#_Id_SolicitudConceptos").val();
    var tiempo = $("#txt_tiempoEntregaAdmin_enConceptos").val();
    var tipoCambio = $("#txt_tipoCambio_Concepto").val();
    if (tiempo == "" || tipoCambio == "") {
      swal({
        type: "error",
        title: "¡Todos los campos marcados con  * son requeridos!",
        showConfirmButton: true,
        confirmButtonText: "Cerrar"
      }).then(function(result) {
        if (result.value) {}
      });
    }else {

      var dato = '{"id_solicitud":"' + id + '",';
      dato += '"soli_tipoCambio_admin":"' + tipoCambio + '",';
      dato += '"soli_tiempo_entrega":"' + tiempo + '"}';
      var datos = new FormData();
      datos.append("_InsertarTiempoEntregaAdmin", dato);
      $.ajax({
        url: "ajax/solicitud.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta) {
          if (respuesta == "ok") {
            swal({
              type: "success",
              title: "Datos guardados correctamente!!",
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
            $("#_btnGenerarDetallesSoli").addClass('hidden');
            $("#txt_tiempoEntregaAdmin_enConceptos").prop("readonly", true);
            $("#txt_tipoCambio_Concepto").prop("readonly", true);
            $(".costos_").removeClass("fa-minus");
            $(".costos_").addClass("fa-plus");
            $(".SuccBox").removeClass("collapsed-box");
            $('.costos_').prop('disabled', false);
            $("#_btnGuardarTiempoEntV").addClass('hidden');
          } else {
            swal({
              type: "error",
              title: "Error al guardar : " + respuesta,
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
          }
        }
      });
    }
}

function CargarDatosParaEditEnConceptos() {
  var id = $("#_Id_SolicitudConceptos").val();
  var datos = new FormData();
  datos.append("_idSolicitud", id);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {

      $("#_Id_SolicitudConceptos").val(respuesta["id_solicitud"]);
      $("#txtIdSolicitud_EnConceptos").val(respuesta["soli_folio"]);
      $("#txt_tituloSolicitud_EnConceptos").val(respuesta["soli_titulo"]);
      $("#txt_responsable_enConceptos").val(respuesta["us_nombre"]);
      $("#txt_empresa_enConceptos").val(respuesta["emp_nombre"]);
      $("#txt_contacto_enConceptos").val(respuesta["cont_nombre"]);
      $("#txtRFCEmpresa_EnConceptos").val(respuesta["emp_rfc"]);
      $("#txtRFCEmpresa_EnAprobacion").val(respuesta["moneda_descripcion"]);


      if (respuesta["soli_folio_Asimex"] !== "") {
        $("#txt_folioDeReferencia_EnConceptos").val(respuesta["soli_folio_Asimex"]);
      } else {
        $("#txt_folioDeReferencia_EnConceptos").val("N/A");
      }
      $("#txtTipoServicio_EnConceptos").val(respuesta["serv_descripcion"]);
      $("#_totalGeneral_EnConceptos").html("$ " + respuesta["soli_total"]);//No se usa ni se muestra en formulario
      if (respuesta["soli_sumatoria_materiales"] !== "" && respuesta["soli_sumatoria_materiales"] !== 0 && respuesta["soli_sumatoria_materiales"] !== null) {
        $("#_lblTotalMateriales").val(respuesta["soli_sumatoria_materiales"]);
      } else {
        $("#_lblTotalMateriales").val("0.00");
      }
      if (respuesta["soli_sumatoria_manoDeObra"] !== "" && respuesta["soli_sumatoria_manoDeObra"] !== 0 && respuesta["soli_sumatoria_manoDeObra"] !== null) {
        $("#_lblTotalManoDeObra").val(respuesta["soli_sumatoria_manoDeObra"]);
      } else {
        $("#_lblTotalManoDeObra").val("0.00");
      }
      if (respuesta["soli_sumatoria_indirectos"] !== "" && respuesta["soli_sumatoria_indirectos"] !== 0 && respuesta["soli_sumatoria_indirectos"] !== null) {
        $("#_lblTotalIndirectos").val(respuesta["soli_sumatoria_indirectos"]);
      } else {
        $("#_lblTotalIndirectos").val("0.00");
      }
      if (respuesta["soli_sumatoria_externos"] !== "" && respuesta["soli_sumatoria_externos"] !== 0 && respuesta["soli_sumatoria_externos"] !== null) {
        $("#_lblTotalExternos").val(respuesta["soli_sumatoria_externos"]);
      } else {
        $("#_lblTotalExternos").val("0.00");
      }
      $("#_lblTotalCostos").val(respuesta["soli_total"]);
      $("#_lblTotalUSD").val(respuesta["soli_total_dlls"]);
      $("._IndividualMat_mxn_G").html("$ " + respuesta['soli_sumInd_materiales_mxn']);
      $("._IndividualMat_usd_G").html("$ " + respuesta['soli_sumInd_materiales_dlls']);
      $("#txt_CantidadPzs_enVerSolicitud").val(respuesta['soli_cantidad_piezas']);

      $("._IndividualHrs_mano").html("$ " + respuesta['soli_sumInd_hrsUnitarias']);
      $("._IndividualMano_mxn").html("$ " + respuesta['soli_sumInd_manoDeObra_mxn']);
      $("._IndividualMano_usd").html("$ " + respuesta['soli_sumInd_manoDeObra_dlls']);

      $("._IndividualInd_mxn_G").html("$ " + respuesta['soli_sumInd_indirectos_mxn']);
      $("._IndividualInd_usd_G").html("$ " + respuesta['soli_sumInd_indirectos_dlls']);

      $("._IndividualExt_mxn").html("$ " + respuesta['soli_sumInd_externos_mxn']);
      $("._IndividualExt_usd").html("$ " + respuesta['soli_sumInd_externos_dlls']);
      if (respuesta['soli_tiempo_entrega'] !== "" && respuesta['soli_tiempo_entrega'] !== undefined && respuesta['soli_tiempo_entrega'] !== null) {
          $(".costos_").addClass("fa-minus");
          $(".costos_").removeClass("fa-plus");
          $(".SuccBox").removeClass("collapsed-box");
          $('.costos_').prop('disabled', false);
          $("#txt_tiempoEntregaAdmin_enConceptos").val(respuesta['soli_tiempo_entrega']);
          $("#_btnGuardarTiempoEntV").addClass('hidden');
          $("#txt_tipoCambio_Concepto").val(respuesta['soli_tipoCambio_admin']);
          $("#txt_tiempoEntregaAdmin_enConceptos").prop("readonly", true);
          $("#txt_tipoCambio_Concepto").prop("readonly", true);
      }else {
        $(".costos_").addClass("fa-plus");
        $(".costos_").removeClass("fa-minus");
        $(".SuccBox").addClass("collapsed-box");
        $('.costos_').prop('disabled', true);
      }
      $("#txt_tiempoEntrega_enConceptos").val(respuesta['soli_fechaEstimada_Entrega']);
      $("#txt_piezas_enConceptos").val(respuesta['soli_cantidad_piezas']);
      if (respuesta["soli_ultimo_tipoCambio"] == "1") {
          $("#txtMoneda_EnConcepto").val("MXN");
      }else {
        $("#txtMoneda_EnConcepto").val("USD");
      }
      /*==============================================================================================================================*/
      var _moneda = respuesta["soli_ultimo_tipoCambio"];
      if (_moneda == "2") {
          if (respuesta["soli_descuento_dlls"] !== "" && respuesta["soli_descuento_dlls"] !== 0 && respuesta["soli_descuento_dlls"] !== null) {
            $("#_descuentoSoli").val(respuesta["soli_descuento_dlls"]);
            $("#_subDescuentoSolicitud").html(respuesta["soli_descuento_dlls"]);
            $("#_descuentoValor").val(respuesta["soli_descuento_dlls"]);
          }
          if (respuesta["soli_iva_dlls"] !== "" && respuesta["soli_iva_dlls"] !== 0 && respuesta["soli_iva_dlls"] !== null) {
            $("#_selectIVA").val(respuesta["soli_IVA_valor"]);
            $("#_IVaSoli").val(respuesta["soli_iva_dlls"]);
            $("#_IVASolicitud").html(respuesta["soli_iva_dlls"]);
          }
          $("#_totalSoli").val(respuesta["soli_totalFinal_dlls"]);
          $("#_totalSolicitud").html(respuesta["soli_totalFinal_dlls"]);
          if (respuesta["soli_subtotal_dlls"] !== "0.00" && respuesta["soli_subtotal_dlls"] !== null && respuesta["soli_subtotal_dlls"] !== "" ) {
            var precioVenta = parseFloat(respuesta['soli_subtotal_dlls']) - parseFloat(respuesta['soli_descuento_dlls']);
            var new_precioVenta = precioVenta.toFixed(2);
            $("#_PrecioDeVentaSoli").val(new_precioVenta);
            var ganancias = parseFloat(new_precioVenta) - parseFloat($("#_lblTotalUSD").val());
            var new_ganancias = ganancias.toFixed(2);
            $("#_ganancias").val(new_ganancias);
          }
      }else {

        if (respuesta["soli_descuento"] !== "" && respuesta["soli_descuento"] !== 0 && respuesta["soli_descuento"] !== null) {
          $("#_descuentoSoli").val(respuesta["soli_descuento"]);
          $("#_subDescuentoSolicitud").html(respuesta["soli_descuento"]);
          $("#_descuentoValor").val(respuesta["soli_descuento"]);
        }
        if (respuesta["soli_IVA"] !== "" && respuesta["soli_IVA"] !== 0 && respuesta["soli_IVA"] !== null) {
          $("#_selectIVA").val(respuesta["soli_IVA_valor"]);
          $("#_IVaSoli").val(respuesta["soli_IVA"]);
          $("#_IVASolicitud").html(respuesta["soli_IVA"]);
        }
        $("#_totalSoli").val(respuesta["soli_totalFinal"]);
        $("#_totalSolicitud").html(respuesta["soli_totalFinal"]);
        if (respuesta["soli_subtotal"] !== "0.00" && respuesta["soli_subtotal"] !== null && respuesta["soli_subtotal"] !== "" ) {
          var precioVenta = parseFloat(respuesta['soli_subtotal']) - parseFloat(respuesta['soli_descuento']);
          var new_precioVenta = precioVenta.toFixed(2);
          $("#_PrecioDeVentaSoli").val(new_precioVenta);
          var ganancias = parseFloat($("#_PrecioDeVentaSoli").val()) - parseFloat($("#_lblTotalCostos").val());
          var new_ganancias = ganancias.toFixed(2);
          $("#_ganancias").val(new_ganancias);
        }
      }
    }
  });
}

function printMateriales_EnConceptos() {
  var idtable = "_tblMateriales";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudConceptos").val();
  var datos = new FormData();
  datos.append("_GetMateriales", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalMateriales_USD = 0;

      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_material'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mat_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mat_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mat_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['mat_importe'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['mat_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";

        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['mat_total']);
        TotalMateriales_USD =  parseFloat(TotalMateriales_USD) + parseFloat(respuesta[i]['mat_total_dlls']);
      }
      TotalMateriales_USD = TotalMateriales_USD.toFixed(2);
      $("#PrintPartidasMateriales_EnConceptos").html(print);
      $("#_paratotales_enMateriales_Conceptos").removeClass("hidden");
      $("#_totalMaterial_EnConceptos").html("$ " + TotalMateriales);
      $("._totalMaterial_USD_G").html("$ " + TotalMateriales_USD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printManoDeObra_EnConceptos() {
  var idtable = "_tblManoDeObra";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudConceptos").val();
  var datos = new FormData();
  datos.append("_GetManoDeObra", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var totalManoDeObra_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_mano_de_obra'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mano_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mano_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mano_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['mano_importe'] + "</td>";
          print += "<td>" + respuesta[i]['mano_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['mano_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['mano_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['mano_total']);
        totalManoDeObra_USD = parseFloat(totalManoDeObra_USD) + parseFloat(respuesta[i]['mano_total_dlls']);
      }
      $("#PrintPartidasManoDeObra_EnConceptos").html(print);
      $("#_paratotales_enManoDeObra_Conceptos").removeClass("hidden");
      $("#_totalManoDeObra_EnConceptos").html("$ " + TotalMateriales);
      $("._totalManoDeObra_USD").html("$ " + totalManoDeObra_USD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printIndirectos_EnConceptos() {
  var idtable = "_tblIndirectos";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudConceptos").val();
  var datos = new FormData();
  datos.append("_GetIndirectos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalIndirectos_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_indirecto'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ind_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ind_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ind_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['ind_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ind_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['ind_total']);
        TotalIndirectos_USD = parseFloat(TotalIndirectos_USD) + parseFloat(respuesta[i]['ind_total_dlls']);
      }
      $("#PrintPartidasIndirectos_EnConceptos").html(print);
      $("#_paratotales_enIndirectos_Conceptos").removeClass("hidden");
      $("#_totalIndirectos_EnConceptos").html("$ " + TotalMateriales);
      $("._totalIndirectos_USD_G").html("$ " + TotalIndirectos_USD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printExternos_EnConceptos() {
  var idtable = "_tblExternos";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudConceptos").val();
  var datos = new FormData();
  datos.append("_GetExternos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var totalExternosUSD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_externo'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ext_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ext_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ext_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['ext_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ext_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['ext_total']);
        totalExternosUSD = parseFloat(totalExternosUSD) + parseFloat(respuesta[i]['ext_total_dlls']);
      }
      $("#PrintPartidasExternos_EnConceptos").html(print);
      $("#_paratotales_enExternos_Conceptos").removeClass("hidden");
      $("#_totalExternos_EnConceptos").html("$ " + TotalMateriales);
      $("._totalExternos_USD").html("$ " + totalExternosUSD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTable_EnConceptos() {
  var table = $('#tablaConceptos').DataTable();
  table.destroy();
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function Table_EnConceptos() {
  $('#tablaConceptos').DataTable({
    "bPaginate": true,
    "bFilter": true,
    "bInfo": true,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}

//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTableGeneric_EnConceptos(idtable) {
  var table = $('#' + idtable).DataTable();
  table.destroy();
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function TableGeneric_EnConceptos(idtable) {
  $('#' + idtable).DataTable({
    "bPaginate": false,
    "bFilter": true,
    "bInfo": false,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}

/*=================================================================
   ====================CONCEPTOS =================================
===================================================================*/
function InsertOrUpdateConceptos_Solicitud() {
  //recibimos los datos del html
  var idSoli = $("#_Id_SolicitudConceptos").val();
  var unidadDeMedida = $("#nuevaUnidad_EnConceptos").val();
  var descripcion = $("#nuevaDescripcion_EnConceptos").val();
  var cantidad = $("#nuevaCantidadProducto_EnConceptos").val();
  //========================================================
  var importe = $("#nuevoPrecioProducto_EnConceptos").val();
  var total = $("#nuevoTotalProducto_EnConceptos").val();
  //========================================================

  var tipoMoneda = $("#txtMoneda_EnConcepto").val();
  var importeChange;
  var totalChange;
  var _idConcepto = $("#_Id_Concepto").val();
  if (unidadDeMedida == "" || descripcion == "" || cantidad == "" || importe == "") {
    swal({
      type: "error",
      title: "¡Todos los campos marcados con  * son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  } else {
    if (_idConcepto == "") {
      _idConcepto = 0;
    }
    var dato = '{"fk_id_solicitud":"' + idSoli + '",';
    dato += '"con_unidadDeMedida":"' + unidadDeMedida + '",';
    dato += '"con_descripcion":"' + descripcion + '",';
    dato += '"con_cantidad":"' + cantidad + '",';

    //El tipo de moneda 1 es igual a MXN
     if (tipoMoneda == "MXN") {
       var tipoCambio = $("#txt_tipoCambio_Concepto").val();
       importeChange = convierteAUSD(Number(importe), Number(tipoCambio));
       totalChange = convierteAUSD(Number(total),Number(tipoCambio));

       dato += '"con_importe":"' + importe + '",';
       dato += '"con_total":"' + total + '",';
       dato += '"con_importe_dlls":"' + importeChange + '",';
       dato += '"con_total_dlls":"' + totalChange + '",';
     }else {
       var tipoCambio = $("#txt_tipoCambio_Concepto").val();
       importeChange = convierteAMXN(Number(importe), Number(tipoCambio));
       totalChange = convierteAMXN(Number(total),Number(tipoCambio));

       dato += '"con_importe":"' + importeChange + '",';
       dato += '"con_total":"' + totalChange + '",';
       dato += '"con_importe_dlls":"' + importe + '",';
       dato += '"con_total_dlls":"' + total + '",';
     }
    dato += '"id_concepto":"' + _idConcepto + '"}';

    var datos = new FormData();
    datos.append("InsertarConceptos", dato);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "insert") {
          swal({
            type: "success",
            title: "¡Datos registrados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addConceptos").addClass('hidden');
          $("#BtnAddPartidasConceptos").removeClass('hidden');
          //Carga las partidas de los materiales
          printConceptos();
          //carga el total general de la solicitud
          // totalDeSolicitud();
        } else if (respuesta == "EditOK") {
          swal({
            type: "success",
            title: "¡Datos actualizados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          $("#_addConceptos").addClass('hidden');
          $("#BtnAddPartidasConceptos").removeClass('hidden');
          //Carga las partidas de los materiales
          printConceptos();
          //carga el total general de la solicitud
          // totalDeSolicitud();
        } else {
          swal({
            type: "error",
            title: "¡Error al realizar petición!" + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }

    });
  }
}

function printConceptos() {
  var nameTabla = "tablaConceptos"
  DestroyTableGeneral(nameTabla);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudConceptos").val();

  var datos = new FormData();
  datos.append("_GetConceptos", idSoli);

  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalManoDeObra = 0;
      var TotalConceptoDlls = 0;
      var moneda = $("#txtMoneda_EnConcepto").val();
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_concepto'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['con_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['con_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['con_descripcion'] + "</td>";
        if (moneda == "MXN") {
          print += "<td>" + respuesta[i]['con_importe'] + "</td>";
          print += "<td>" + respuesta[i]['con_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['con_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['con_total_dlls'] + "</td>";
        }
        print += "<td>";
        print += "<div class='btn-group'>";
        print += "<a class='btn btn-warning EditConceptos' idSoli=" + respuesta[i]['id_concepto'] + "><i class='fa fa-pencil'></i></a>";
        print += "<a class='btn btn-danger DeleteConceptos' idDelete=" + respuesta[i]['id_concepto'] + "><i class='fa fa-times'></i></a>";
        print += "</div>";
        print += "</td>";
        print += "</tr>";
        TotalManoDeObra = parseFloat(TotalManoDeObra) + parseFloat(respuesta[i]['con_total']);
        TotalConceptoDlls = parseFloat(TotalConceptoDlls) + parseFloat(respuesta[i]['con_total_dlls']);
      }
      $("#PrintPartidasConceptos").html(print);
      TableGeneral(nameTabla);
      $("#_paratotales_enConceptos").removeClass("hidden");
      var moneda2 = $("#txtMoneda_EnConcepto").val();
      if (moneda2 == "MXN") {
        $("#_subtotalSolicitud").html(TotalManoDeObra);
        $("#_subtotalSoli").val(TotalManoDeObra);
        var valorr =  $("#_subtotalSoli").val();
        if ($("#_subtotalSoli").val() !== "0" && $("#_subtotalSoli").val()  !== ""){
          var precioVenta = parseFloat($("#_subtotalSoli").val()) - parseFloat($("#_descuentoSoli").val());
          var new_precioVenta = precioVenta.toFixed(2);
          $("#_PrecioDeVentaSoli").val(new_precioVenta);

          var ganancias = parseFloat($("#_PrecioDeVentaSoli").val()) - parseFloat($("#_lblTotalCostos").val());
          var new_ganancias = ganancias.toFixed(2);
          $("#_ganancias").val(new_ganancias);
        }
      }else {
        $("#_subtotalSolicitud").html(TotalConceptoDlls);
        $("#_subtotalSoli").val(TotalConceptoDlls);

        var valorr =  $("#_subtotalSoli").val();
        if ($("#_subtotalSoli").val() !== "0" && $("#_subtotalSoli").val()  !== ""){
          var precioVenta = parseFloat($("#_subtotalSoli").val()) - parseFloat($("#_descuentoSoli").val());
          var new_precioVenta = precioVenta.toFixed(2);
          $("#_PrecioDeVentaSoli").val(new_precioVenta);

          var ganancias = parseFloat($("#_PrecioDeVentaSoli").val()) - parseFloat($("#_lblTotalUSD").val());
          var new_ganancias = ganancias.toFixed(2);
          $("#_ganancias").val(new_ganancias);
        }
      }
      //$("._FinExternos").removeClass('hidden');

      $("#_ApartadoCostos").removeClass("hidden");
      $("#_apartadoTotales").removeClass("hidden");
      var _des = $("#_descuentoValor").val();
      var _por = $("#descuentoPorcentaje").val();
      if (_des !== "" && _des !== 0) {
        calcularDescuentoSinPorcentaje();
        guardarTotalesSolicitudSinMSJ();
      } else if (_por !== "" && _por !== 0) {
        calcularDescuentoPorcentaje();
        guardarTotalesSolicitudSinMSJ();
      }

      if (print == "") {
        $("#btnGuardaSolicitud").addClass('hidden');
        $("#btnEnviaraAprobacion").addClass('hidden');
      }else {
        $("#btnGuardaSolicitud").removeClass('hidden');
        $("#btnEnviaraAprobacion").removeClass('hidden');
      }
    }
  })
}
//Elimina las propiedades de la tabla de acuerdo al ID
function DestroyTableGeneral(id) {
  var table = $('#' + id).DataTable();
  table.destroy();
}
/*=============================================
  PROPIEDADES PARA CREAR TABLA
=============================================*/
function TableGeneral(id) {
  $('#' + id).DataTable({
    "bPaginate": false,
    "bFilter": false,
    "bInfo": false,
    "language": {
      "sProcessing": "Procesando...",
      "sLengthMenu": "Mostrar _MENU_ registros",
      "sZeroRecords": "No se encontraron resultados",
      "sEmptyTable": "Ningún dato disponible en esta tabla",
      "sInfo": "Mostrando registros del _START_ al _END_ de un total de _TOTAL_ registros",
      "sInfoEmpty": "Mostrando registros del 0 al 0 de un total de 0 registros",
      "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
      "sInfoPostFix": "",
      "sSearch": "Buscar:",
      "sUrl": "",
      "sInfoThousands": ",",
      "sLoadingRecords": "Cargando...",
      "oPaginate": {
        "sFirst": "Primero",
        "sLast": "Último",
        "sNext": "Siguiente",
        "sPrevious": "Anterior"
      },
      "oAria": {
        "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
        "sSortDescending": ": Activar para ordenar la columna de manera descendente"
      }
    },
    "lengthMenu": [
      [5, 10, 20, -1],
      [5, 10, 20, "Todos"]
    ]

  });
}
/*=============================================
  ELIMINAR PARTIDAS DE EXTERNOS
=============================================*/
function EliminarConcepto(idEliminar) {
  var id = $("#_Id_SolicitudConceptos").val();

  var dato = '{"id_solicitud":"' + id + '",';
  dato += '"idConcepto":"' + idEliminar + '"}';
  var datos = new FormData();
  datos.append("idConcepto", dato);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Partida eliminada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
        //Carga las partidas de los materiales
        printConceptos();
        //carga el total general de la solicitud
        //totalDeSolicitud();
      } else {
        swal({
          type: "error",
          title: "error al intentar eliminada!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
      }

    }
  })
}
/*=============================================
GET INFORMACION DE PRODUCTO PARA EDITAR
=============================================*/
function GetDatosConceptos(idPartida) {

  var datos = new FormData();
  datos.append("id_concepto", idPartida);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#_Id_SolicitudConceptos").val(respuesta["id_solicitud"]);
      $("#_Id_Concepto").val(respuesta["id_concepto"]);
      $("#nuevaUnidad_EnConceptos").val(respuesta["con_unidadDeMedida"]);
      $("#nuevaDescripcion_EnConceptos").val(respuesta["con_descripcion"]);
      $("#nuevaCantidadProducto_EnConceptos").val(respuesta["con_cantidad"]);
      $("#nuevoPrecioProducto_EnConceptos").val(respuesta["con_importe"]);
      $("#nuevoTotalProducto_EnConceptos").val(respuesta["con_total"]);
    }
  });
}

//*******************************|| 03 / 03 / 2019 ||***************************************************************************************
/*=============================================
      DESCUENTO EN PORCENTAJE
=============================================*/
$(".descuentoPorcentaje_EnConceptos").change(function() {
  if ($(".porcentaje_EnConcepto").prop("checked")) {
    calcularDescuentoPorcentaje();
  }
})
/*=============================================
      DESHABILITAR DESCUENTO
=============================================*/
$(".porcentaje_EnConcepto").on("ifUnchecked", function() {
  $(".descuentoPorcentaje_EnConceptos").prop("readonly", true);
  $("#_descuentoValor").prop("readonly", false);
  $(".descuentoPorcentaje_EnConceptos").val("0");

  /* $("#trDescuento").addClass('hidden');
    $("#trIVA").addClass('hidden');
    $("#trTotal").addClass('hidden');*/
  calcularDescuentoSinPorcentaje();
})

/*=============================================
      HABILITAR DESCUENTO
=============================================*/
$(".porcentaje_EnConcepto").on("ifChecked", function() {

  $(".descuentoPorcentaje_EnConceptos").prop("readonly", false);
  $("#_descuentoValor").prop("readonly", true);
  $("#_descuentoValor").val("0");

  /*$("#trDescuento").addClass('hidden');
  $("#trIVA").addClass('hidden');
  $("#trTotal").addClass('hidden');*/


  calcularDescuentoPorcentaje();
})

$("#_descuentoValor").change(function() {

  if ($(".porcentaje_EnConcepto").prop("checked")) {

  } else {
    calcularDescuentoSinPorcentaje();
  }

})

function calcularDescuentoPorcentaje() {
  var moneda = $("#txtMoneda_EnConcepto").val();
  if (moneda == "MXN") {
    var subtotal = $("#_subtotalSoli").val();
    $("#_descuentoValor").val("0");
    //console.log("subtotal",subtotal);
    var descuento = ((subtotal * $(".descuentoPorcentaje_EnConceptos").val()) / 100);
    var new_descuento = descuento.toFixed(2);
    //console.log("descuento",descuento);
    subtotal = Number(subtotal) - Number(new_descuento);
    //console.log("subtotal descuento",subtotal);
    var iva = subtotal * parseFloat($("#_selectIVA").val());
    //console.log("iva",iva);
    var new_iva = iva.toFixed(2);
    var total = Number(subtotal) + Number(iva);
    var new_total = total.toFixed(2);
    //console.log("total",total);
    //Removemos la clase hidden del tr del descuento
    $("#trDescuento").removeClass('hidden');
    $("#_subDescuentoSolicitud").html(new_descuento);

    $("#_descuentoSoli").val(new_descuento);
    //Removemos la clase hidden del tr del IVA
    $("#trIVA").removeClass('hidden');
    $("#_IVASolicitud").html(new_iva);

    $("#_IVaSoli").val(new_iva);
    //Removemos la clase hidden del tr del TOTAL
    $("#trTotal").removeClass('hidden');
    $("#_totalSolicitud").html(new_total);
    $("#_totalSoli").val(new_total);

    if ($("#_subtotalSoli").val() !== "0" && $("#_subtotalSoli").val()  !== ""){
      var precioVenta = parseFloat($("#_subtotalSoli").val()) - parseFloat($("#_descuentoSoli").val());
      var new_precioVenta = precioVenta.toFixed(2);
      $("#_PrecioDeVentaSoli").val(new_precioVenta);

      var ganancias = parseFloat($("#_PrecioDeVentaSoli").val()) - parseFloat($("#_lblTotalCostos").val());
      var new_ganancias = ganancias.toFixed(2);
      $("#_ganancias").val(new_ganancias);
    }
  }else {
      var subtotal = $("#_subtotalSoli").val();
      $("#_descuentoValor").val("0");
      //console.log("subtotal",subtotal);
      var descuento = ((subtotal * $(".descuentoPorcentaje_EnConceptos").val()) / 100);
      var new_descuento = descuento.toFixed(2);
      //console.log("descuento",descuento);
      subtotal = Number(subtotal) - Number(new_descuento);
      //console.log("subtotal descuento",subtotal);
      var iva = subtotal * parseFloat($("#_selectIVA").val());
      //console.log("iva",iva);
      var new_iva = iva.toFixed(2);
      var total = Number(subtotal) + Number(iva);

      var new_total = total.toFixed(2);

      //console.log("total",total);
      //Removemos la clase hidden del tr del descuento
      $("#trDescuento").removeClass('hidden');
      $("#_subDescuentoSolicitud").html(new_descuento);

      $("#_descuentoSoli").val(new_descuento);
      //Removemos la clase hidden del tr del IVA
      $("#trIVA").removeClass('hidden');
      $("#_IVASolicitud").html(new_iva);

      $("#_IVaSoli").val(new_iva);
      //Removemos la clase hidden del tr del TOTAL
      $("#trTotal").removeClass('hidden');
      $("#_totalSolicitud").html(new_total);
      $("#_totalSoli").val(new_total);

      if ($("#_subtotalSoli").val() !== "0" && $("#_subtotalSoli").val()  !== ""){
        var precioVenta = parseFloat($("#_subtotalSoli").val()) - parseFloat($("#_descuentoSoli").val());
        var new_precioVenta = precioVenta.toFixed(2);
        $("#_PrecioDeVentaSoli").val(new_precioVenta);

        var ganancias = parseFloat($("#_PrecioDeVentaSoli").val()) - parseFloat($("#_lblTotalUSD").val());
        var new_ganancias = ganancias.toFixed(2);
        $("#_ganancias").val(new_ganancias);
      }
  }

}

function calcularDescuentoSinPorcentaje() {
  var moneda = $("#txtMoneda_EnConcepto").val();
  if (moneda == "MXN") {
    $(".descuentoPorcentaje").prop("readonly", true);
    var subtotal = $("#_subtotalSoli").val();
    //console.log("subtotal",subtotal);
    var descuento = $("#_descuentoValor").val();
    //console.log("descuento",descuento);
    subtotal = Number(subtotal) - Number(descuento);
    var iva = subtotal * parseFloat($("#_selectIVA").val());
    var new_iva = iva.toFixed(2);
    var total = Number(subtotal) + Number(iva);
    var new_total = total.toFixed(2);
    //Removemos la clase hidden del tr del descuento
    $("#trDescuento").removeClass('hidden');
    $("#_subDescuentoSolicitud").html(descuento);
    var v = $("#_descuentoSoli").val();
    $("#_descuentoSoli").val(descuento);
    //Removemos la clase hidden del tr del IVA
    $("#trIVA").removeClass('hidden');
    $("#_IVASolicitud").html(new_iva);
    $("#_IVaSoli").val(new_iva);
    //Removemos la clase hidden del tr del TOTAL
    $("#trTotal").removeClass('hidden');
    $("#_totalSolicitud").html(new_total);
    $("#_totalSoli").val(new_total);
    if ($("#_subtotalSoli").val() !== "0" && $("#_subtotalSoli").val()  !== ""){
      var precioVenta = parseFloat($("#_subtotalSoli").val()) - parseFloat($("#_descuentoSoli").val());
      var new_precioVenta = precioVenta.toFixed(2);
      $("#_PrecioDeVentaSoli").val(new_precioVenta);
      var ganancias = parseFloat($("#_PrecioDeVentaSoli").val()) - parseFloat($("#_lblTotalCostos").val());
      var new_ganancias = ganancias.toFixed(2);
      $("#_ganancias").val(new_ganancias);
    }
  }else {
    $(".descuentoPorcentaje").prop("readonly", true);
    var subtotal = $("#_subtotalSoli").val();
    //console.log("subtotal",subtotal);
    var descuento = $("#_descuentoValor").val();
    //console.log("descuento",descuento);
    subtotal = Number(subtotal) - Number(descuento);
    var iva = subtotal * parseFloat($("#_selectIVA").val());
    var new_iva = iva.toFixed(2);
    var total = Number(subtotal) + Number(iva);
    var new_total = total.toFixed(2);
    //Removemos la clase hidden del tr del descuento
    $("#trDescuento").removeClass('hidden');
    $("#_subDescuentoSolicitud").html(descuento);
    var v = $("#_descuentoSoli").val();
    $("#_descuentoSoli").val(descuento);
    //Removemos la clase hidden del tr del IVA
    $("#trIVA").removeClass('hidden');
    $("#_IVASolicitud").html(new_iva);
    $("#_IVaSoli").val(new_iva);
    //Removemos la clase hidden del tr del TOTAL
    $("#trTotal").removeClass('hidden');
    $("#_totalSolicitud").html(new_total);
    $("#_totalSoli").val(new_total);
    if ($("#_subtotalSoli").val() !== "0" && $("#_subtotalSoli").val()  !== ""){
      var precioVenta = parseFloat($("#_subtotalSoli").val()) - parseFloat($("#_descuentoSoli").val());
      var new_precioVenta = precioVenta.toFixed(2);
      $("#_PrecioDeVentaSoli").val(new_precioVenta);
      var ganancias = parseFloat($("#_PrecioDeVentaSoli").val()) - parseFloat($("#_lblTotalUSD").val());
      var new_ganancias = ganancias.toFixed(2);
      $("#_ganancias").val(new_ganancias);
    }
  }
}
$("#_selectIVA").change(function() {
  if ($(".porcentaje_EnConcepto").prop("checked")) {
    var _por = $("#descuentoPorcentaje").val();
    if (_por !== "" && _por !== 0) {
      calcularDescuentoPorcentaje();
    }
  } else {
    var des = $("#_descuentoValor").val();
    if (des !== "" && des !== 0) {
      calcularDescuentoSinPorcentaje();

    }
  }
})

function guardarTotalesSolicitud() {

  var idSoli = $("#_Id_SolicitudConceptos").val();
  var _subsoli = $("#_subtotalSoli").val();
  var _descuento = $("#_descuentoSoli").val();
  var _iva = $("#_IVaSoli").val();
  var _totalSoli = $("#_totalSoli").val();
  var _ivaSol = $("#_selectIVA").val();

  /*===============================================*/
  var tipoMoneda =  $("#txtMoneda_EnConcepto").val();
  var tipoCambio =  $("#txt_tipoCambio_Concepto").val();
  /*=================================================*/

  var subtotalChange;
  var desuentoChange;
  var ivaChange;
  var totalFinalChange;
  if (_subsoli == "") {
    _subsoli = 0;
  }
  if (_descuento == "") {
    _descuento = 0;
  }
  if (_iva == "") {
    _iva = 0;
  }
  if (_totalSoli == "") {
    _totalSoli = 0;
  }

  var dato = '{"id_solicitud":"' + idSoli + '",';
  dato += '"soli_IVA_valor":"' + _ivaSol + '",';
  if (tipoMoneda == "MXN") {
    subtotalChange = convierteAUSD(Number(_subsoli), Number(tipoCambio));
    desuentoChange = convierteAUSD(Number(_descuento), Number(tipoCambio));
    ivaChange = convierteAUSD(Number(_iva), Number(tipoCambio));
    totalFinalChange = convierteAUSD(Number(_totalSoli), Number(tipoCambio));
    dato += '"soli_subtotal":"' + _subsoli + '",';
    dato += '"soli_subtotal_dlls":"' + subtotalChange + '",';
    dato += '"soli_descuento":"' + _descuento + '",';
    dato += '"soli_descuento_dlls":"' + desuentoChange + '",';
    dato += '"soli_IVA":"' + _iva + '",';
    dato += '"soli_iva_dlls":"' + ivaChange + '",';
    dato += '"soli_totalFinal_dlls":"' + totalFinalChange + '",';
    dato += '"soli_totalFinal":"' + _totalSoli + '"}';
  }else {
    subtotalChange = convierteAMXN(Number(_subsoli), Number(tipoCambio));
    desuentoChange = convierteAMXN(Number(_descuento), Number(tipoCambio));
    ivaChange = convierteAMXN(Number(_iva), Number(tipoCambio));
    totalFinalChange = convierteAMXN(Number(_totalSoli), Number(tipoCambio));

    dato += '"soli_subtotal":"' + subtotalChange  + '",';
    dato += '"soli_subtotal_dlls":"' + _subsoli + '",';
    dato += '"soli_descuento":"' +  desuentoChange + '",';
    dato += '"soli_descuento_dlls":"' + _descuento + '",';
    dato += '"soli_IVA":"' +  ivaChange + '",';
    dato += '"soli_iva_dlls":"' + _iva + '",';
    dato += '"soli_totalFinal_dlls":"' +  _totalSoli + '",';
    dato += '"soli_totalFinal":"' + totalFinalChange + '"}';

  }
  var datos = new FormData();
  datos.append("InsertarTotalesSoli", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Datos registrados correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function enviaraAprobacion_solicitud() {
  var idSoli = $("#_Id_SolicitudConceptos").val();
  //var dato = '{"id_solicitud":"' + idSoli + '"}';

  var datos = new FormData();
  datos.append("enviaraAprobacion", idSoli);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Solicitud Enviada Correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {
            document.location = "solicitudes";
          }
        });
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}
/*============================================================
    APARTADO PARA ASIGNACION DE RESPONSABLE
===============================================================*/
function GetDatosAsignacion(id) {
  var datos = new FormData();
  datos.append("_idSolicitud", id);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#lbl_folioSolicitud").val(respuesta["soli_folio"]);
      $("#lbl_tituloSolicitud").val(respuesta["soli_titulo"]);
      $("#lbl_nombreEmpresa").val(respuesta["emp_nombre"]);
      $("#lbl_nombreEmpresa").val(respuesta["emp_nombre"]);
      $("#_idSoli").val(respuesta["id_solicitud"]);

    }
  });
}

/*=============================================================================
    APARTADO PARA MOSTRAR LOS CONCEPTOS EN MODULO DE APROBACION DE SOLICITUDES
==============================================================================*/
function printConceptos_enAprobacion() {
  var nameTabla = "tablaConceptos_enAprobacion";
  DestroyTableGeneral(nameTabla);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudAprobacion").val();
  var datos = new FormData();
  datos.append("_GetConceptos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {

      var print = "";
      var moneda = $("#txtMoneda_EnAprobacion").val();
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_concepto'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['con_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['con_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['con_descripcion'] + "</td>";
        if (moneda == "MXN") {
          print += "<td>" + respuesta[i]['con_importe'] + "</td>";
          print += "<td>" + respuesta[i]['con_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['con_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['con_total_dlls'] + "</td>";
        }
        print += "</tr>";
      }
      $("#PrintPartidasConceptos_enAprobacion").html(print);
      TableGeneric_EnConceptos(nameTabla);
    }
  })
}


/*============================================================
   GET A LA INFORMACION GENERAL DE LA SOLICITUD ''APROBACION''
===============================================================*/

function CargarDatosParaEditEnAprobacion() {
  var id = $("#_Id_SolicitudAprobacion").val();
  var datos = new FormData();
  datos.append("_idSolicitud", id);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {

      $("#_Id_SolicitudAprobacion").val(respuesta["id_solicitud"]);
      $("#txtIdSolicitud_EnAprobacion").val(respuesta["soli_folio"]);
      $("#txt_tituloSolicitud_EnAprobacion").val(respuesta["soli_titulo"]);
      $("#txt_responsable_enAprobacion").val(respuesta["us_nombre"]);
      $("#txt_empresa_enAprobacion").val(respuesta["emp_nombre"]);
      $("#txt_contacto_enApobacion").val(respuesta["cont_nombre"]);
      $("#txtRFCEmpresa_EnAprobacion").val(respuesta["emp_rfc"]);
      $("#txt_tiempoEntrega_enAprobacion").val(respuesta["soli_tiempo_entrega"]);
      $("#_txtNotasDeVisita_EnAprobacion").val(respuesta["soli_desc_notasDeVisita"]);
      $("#_lblTotalCostos_enAprobacion").val(respuesta["soli_total"]);
      $("#_lblTotalUSD_EnAprobar").val(respuesta["soli_total_dlls"]);

      if (respuesta["soli_folio_Asimex"] !== "") {
        $("#txt_folioDeReferencia_EnAprobacion").val(respuesta["soli_folio_Asimex"]);
      } else {
        $("#txt_folioDeReferencia_EnAprobacion").val("N/A");
      }
      $("#txtTipoServicio_EnAprobacion").val(respuesta["serv_descripcion"]);


      /*===================================================================================*/
      if (respuesta["soli_ultimo_tipoCambio"] == "1") {
        $("#txtMoneda_EnAprobacion").val("MXN");
          $("#_subtotalSolicitud_EnAprobacion").val(respuesta["soli_subtotal"]);

          if (respuesta["soli_descuento"] !== "" && respuesta["soli_descuento"] !== 0 && respuesta["soli_descuento"] !== null) {
            $("#_descuentoSoli_EnAprobacion").val(respuesta["soli_descuento"]);
            $("#_subDescuentoSolicitud").html(respuesta["soli_descuento"]);

          }
          if (respuesta["soli_IVA"] !== "" && respuesta["soli_IVA"] !== 0 && respuesta["soli_IVA"] !== null) {
            $("#_IVaSoli_EnAprobacion").val(respuesta["soli_IVA"]);
            $("#_IVASolicitud").html(respuesta["soli_IVA"]);
          }
          $("#_totalSoli_enAprobacion").val(respuesta["soli_totalFinal"]);

          if (respuesta["soli_subtotal"]) {
            var precioVenta = parseFloat(respuesta['soli_subtotal']) - parseFloat(respuesta['soli_descuento']);
            var new_precioVenta = precioVenta.toFixed(2);
            $("#_PrecioDeVentaSoli_EnAprobacion").val(new_precioVenta);
            var ganancias = parseFloat($("#_PrecioDeVentaSoli_EnAprobacion").val()) - parseFloat($("#_lblTotalCostos_enAprobacion").val());
            var new_ganancias = ganancias.toFixed(2);
            $("#_ganancias_enAprobacion").val(new_ganancias);
          }

      }else {
        $("#txtMoneda_EnAprobacion").val("USD");
        $("#_subtotalSolicitud_EnAprobacion").val(respuesta["soli_subtotal_dlls"]);
        if (respuesta["soli_descuento_dlls"] !== "" && respuesta["soli_descuento_dlls"] !== 0 && respuesta["soli_descuento_dlls"] !== null) {
          $("#_descuentoSoli_EnAprobacion").val(respuesta["soli_descuento_dlls"]);
          $("#_subDescuentoSolicitud").html(respuesta["soli_descuento_dlls"]);

        }
        if (respuesta["soli_iva_dlls"] !== "" && respuesta["soli_iva_dlls"] !== 0 && respuesta["soli_iva_dlls"] !== null) {
          $("#_IVaSoli_EnAprobacion").val(respuesta["soli_iva_dlls"]);
          $("#_IVASolicitud").html(respuesta["soli_iva_dlls"]);
        }
        $("#_totalSoli_enAprobacion").val(respuesta["soli_totalFinal_dlls"]);

        if (respuesta["soli_subtotal_dlls"]) {
          var precioVenta = parseFloat(respuesta['soli_subtotal_dlls']) - parseFloat(respuesta['soli_descuento_dlls']);
          var new_precioVenta = precioVenta.toFixed(2);
          $("#_PrecioDeVentaSoli_EnAprobacion").val(new_precioVenta);
          var ganancias = parseFloat($("#_PrecioDeVentaSoli_EnAprobacion").val()) - parseFloat($("#_lblTotalUSD_EnAprobar").val());
          var new_ganancias = ganancias.toFixed(2);
          $("#_ganancias_enAprobacion").val(new_ganancias);
        }
      }


      /*==================================================================*/

      if (respuesta["soli_sumatoria_materiales"] !== "" && respuesta["soli_sumatoria_materiales"] !== 0 && respuesta["soli_sumatoria_materiales"] !== null) {
        $("#_lblTotalMateriales_enAprobacion").val(respuesta["soli_sumatoria_materiales"]);
      } else {
        $("#_lblTotalMateriales_enAprobacion").val("0.00");
      }
      if (respuesta["soli_sumatoria_manoDeObra"] !== "" && respuesta["soli_sumatoria_manoDeObra"] !== 0 && respuesta["soli_sumatoria_manoDeObra"] !== null) {
        $("#_lblTotalManoDeObra_enAprobacion").val(respuesta["soli_sumatoria_manoDeObra"]);
      } else {
        $("#_lblTotalManoDeObra_enAprobacion").val("0.00");
      }
      if (respuesta["soli_sumatoria_indirectos"] !== "" && respuesta["soli_sumatoria_indirectos"] !== 0 && respuesta["soli_sumatoria_indirectos"] !== null) {
        $("#_lblTotalIndirectos_enAprobacion").val(respuesta["soli_sumatoria_indirectos"]);
      } else {
        $("#_lblTotalIndirectos_enAprobacion").val("0.00");
      }
      if (respuesta["soli_sumatoria_externos"] !== "" && respuesta["soli_sumatoria_externos"] !== 0 && respuesta["soli_sumatoria_externos"] !== null) {
        $("#_lblTotalExternos_enAprobacion").val(respuesta["soli_sumatoria_externos"]);
      } else {
        $("#_lblTotalExternos_enAprobacion").val("0.00");
      }

      $("._IndividualMat_mxn_G").html("$ " + respuesta['soli_sumInd_materiales_mxn']);
      $("._IndividualMat_usd_G").html("$ " + respuesta['soli_sumInd_materiales_dlls']);
      $("#txt_CantidadPzs_enVerSolicitud").val(respuesta['soli_cantidad_piezas']);
      $("._IndividualHrs_mano").html("$ " + respuesta['soli_sumInd_hrsUnitarias']);
      $("._IndividualMano_mxn").html("$ " + respuesta['soli_sumInd_manoDeObra_mxn']);
      $("._IndividualMano_usd").html("$ " + respuesta['soli_sumInd_manoDeObra_dlls']);
      $("._IndividualInd_mxn_G").html("$ " + respuesta['soli_sumInd_indirectos_mxn']);
      $("._IndividualInd_usd_G").html("$ " + respuesta['soli_sumInd_indirectos_dlls']);
      $("._IndividualExt_mxn").html("$ " + respuesta['soli_sumInd_externos_mxn']);
      $("._IndividualExt_usd").html("$ " + respuesta['soli_sumInd_externos_dlls']);
    }
  });
}

function guardarTotalesSolicitudSinMSJ() {

  var idSoli = $("#_Id_SolicitudConceptos").val();
  var _subsoli = $("#_subtotalSoli").val();
  var _descuento = $("#_descuentoSoli").val();
  var _iva = $("#_IVaSoli").val();
  var _totalSoli = $("#_totalSoli").val();
  var _ivaSol = $("#_selectIVA").val();
  /*===============================================*/
   var tipoMoneda =  $("#txtMoneda_EnConcepto").val();
   var tipoCambio =  $("#txt_tipoCambio_Concepto").val();
   /*=================================================*/
   var subtotalChange;
   var desuentoChange;
   var ivaChange;
   var totalFinalChange;
  if (_subsoli == "") {
    _subsoli = 0;
  }
  if (_descuento == "") {
    _descuento = 0;
  }
  if (_iva == "") {
    _iva = 0;
  }
  if (_totalSoli == "") {
    _totalSoli = 0;
  }

  var dato = '{"id_solicitud":"' + idSoli + '",';
  dato += '"soli_IVA_valor":"' + _ivaSol + '",';

    if (tipoMoneda == "MXN") {
      subtotalChange = convierteAUSD(Number(_subsoli), Number(tipoCambio));
      desuentoChange = convierteAUSD(Number(_descuento), Number(tipoCambio));
      ivaChange = convierteAUSD(Number(_iva), Number(tipoCambio));
      totalFinalChange = convierteAUSD(Number(_totalSoli), Number(tipoCambio));
      dato += '"soli_subtotal":"' + _subsoli + '",';
      dato += '"soli_subtotal_dlls":"' + subtotalChange + '",';
      dato += '"soli_descuento":"' + _descuento + '",';
      dato += '"soli_descuento_dlls":"' + desuentoChange + '",';
      dato += '"soli_IVA":"' + _iva + '",';
      dato += '"soli_iva_dlls":"' + ivaChange + '",';
      dato += '"soli_totalFinal_dlls":"' + totalFinalChange + '",';
      dato += '"soli_totalFinal":"' + _totalSoli + '"}';
    }else {
      subtotalChange = convierteAMXN(Number(_subsoli), Number(tipoCambio));
      desuentoChange = convierteAMXN(Number(_descuento), Number(tipoCambio));
      ivaChange = convierteAMXN(Number(_iva), Number(tipoCambio));
      totalFinalChange = convierteAMXN(Number(_totalSoli), Number(tipoCambio));

      dato += '"soli_subtotal":"' + subtotalChange  + '",';
      dato += '"soli_subtotal_dlls":"' + _subsoli + '",';
      dato += '"soli_descuento":"' +  desuentoChange + '",';
      dato += '"soli_descuento_dlls":"' + _descuento + '",';
      dato += '"soli_IVA":"' +  ivaChange + '",';
      dato += '"soli_iva_dlls":"' + _iva + '",';
      dato += '"soli_totalFinal_dlls":"' +  _totalSoli + '",';
      dato += '"soli_totalFinal":"' + totalFinalChange + '"}';

    }

  var datos = new FormData();
  datos.append("InsertarTotalesSoli", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {} else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function printMateriales_enAprobacion() {
  var idtable = "_tblMateriales_EnAprobacion";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudAprobacion").val();
  var datos = new FormData();
  datos.append("_GetMateriales", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalMateriales_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_material'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mat_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mat_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mat_descripcion'] + "</td>";

        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['mat_importe'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['mat_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['mat_total']);
        TotalMateriales_USD =  parseFloat(TotalMateriales_USD) + parseFloat(respuesta[i]['mat_total_dlls']);
      }
      TotalMateriales_USD = TotalMateriales_USD.toFixed(2);
      $("#PrintPartidasMateriales_EnAprobacion").html(print);
      $("#_paratotales_enMateriales_Aprobacion").removeClass("hidden");
      $("#_totalMaterial_EnAprobacion").html("$ " + TotalMateriales);
      $("._totalMaterial_USD_G").html("$ " + TotalMateriales_USD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printManoDeObra_EnAprobacion() {
  var idtable = "_tblManoDeObra_enAprobacion";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudAprobacion").val();
  var datos = new FormData();
  datos.append("_GetManoDeObra", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var totalManoDeObra_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_mano_de_obra'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mano_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mano_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mano_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
                 print += "<td>" + respuesta[i]['mano_importe'] + "</td>";
                 print += "<td>" + respuesta[i]['mano_total'] + "</td>";
       }else {
         print += "<td>" + respuesta[i]['mano_importe_dlls'] + "</td>";
         print += "<td>" + respuesta[i]['mano_total_dlls'] + "</td>";
       }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['mano_total']);
        totalManoDeObra_USD = parseFloat(totalManoDeObra_USD) + parseFloat(respuesta[i]['mano_total_dlls']);
      }
      $("#PrintPartidasManoDeObra_EnAprobacion").html(print);
      $("#_paratotales_enManoDeObra_Aprobacion").removeClass("hidden");
      $("#_totalManoDeObra_EnAprobacion").html("$ " + TotalMateriales);
      $("._totalManoDeObra_USD").html("$ " + totalManoDeObra_USD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printIndirectos_EnAprobacion() {
  var idtable = "_tblIndirectos_enAprobacion";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudAprobacion").val();
  var datos = new FormData();
  datos.append("_GetIndirectos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalIndirectos_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_indirecto'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ind_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ind_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ind_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['ind_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ind_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['ind_total']);
        TotalIndirectos_USD = parseFloat(TotalIndirectos_USD) + parseFloat(respuesta[i]['ind_total_dlls']);
      }
      $("#PrintPartidasIndirectos_EnAprobacion").html(print);
      $("#_paratotales_enIndirectos_Aprobacion").removeClass("hidden");
      $("#_totalIndirectos_EnAprobacion").html("$ " + TotalMateriales);
      $("._totalIndirectos_USD_G").html("$ " + TotalIndirectos_USD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printExternos_EnAprobacion() {
  var idtable = "_tblExternos_enAprobacion";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudAprobacion").val();
  var datos = new FormData();
  datos.append("_GetExternos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var totalExternosUSD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_externo'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ext_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ext_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ext_descripcion'] + "</td>";

        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['ext_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ext_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['ext_total']);
        totalExternosUSD = parseFloat(totalExternosUSD) + parseFloat(respuesta[i]['ext_total_dlls']);
      }
      $("#PrintPartidasExternos_EnAprobacion").html(print);
      $("#_paratotales_enExternos_Aprobacion").removeClass("hidden");
      $("#_totalExternos_EnAprobacion").html("$ " + TotalMateriales);
      $("._totalExternos_USD").html("$ " + totalExternosUSD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}


/*=================================================================
   SE APRUEBA LA SOLICITUD POR EL ROL DE GERENTE Y PASA A STATUS 6
==================================================================*/
function AprobarSolicitud(){
  var idSoli = $("#_Id_SolicitudAprobacion").val();
  var status = 6;
  var dato = '{"id_solicitud":"' + idSoli + '",';
  dato += '"fk_id_status":"' + status + '"}';
  var datos = new FormData();
  datos.append("aprobarSolicitud", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Solicitud aprobada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {
            document.location = "solicitudes";
          }
        });
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}
/*style="display: block;" PARA QUE UN MODAL SE ACTIVE EN PANTALLA*/
/*=================================================================
  RECHAZAR SOLICITUD Y ENVIAR COMENTARIOS
==================================================================*/
function RechazarSolicitud(){

  var idSoli = $("#_Id_SolicitudAprobacion").val();
  var status = $("#selectDepart").val();
  var comentarios = $("#_txtmotivoRechazo").val();
  if (comentarios == "") {
    swal({
      type: "error",
      title: "¡Es necesario colocar un comentario",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  }else {
    var dato = '{"id_solicitud":"' + idSoli + '",';
    dato += '"soli_motivoRechazo":"' + comentarios + '",';
    dato += '"fk_id_status":"' + status + '"}';
    var datos = new FormData();
    datos.append("rechazarSolicitud", dato);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "ok") {
          swal({
            type: "success",
            title: "¡Datos guardados correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {
              document.location = "solicitudes";
            }
          });
        } else {
          swal({
            type: "error",
            title: "¡Error al realizar petición!" + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }
    });
  }

}

/*=================================================================
  RECHAZAR SOLICITUD Y ENVIAR COMENTARIOS
==================================================================*/
function CancelarSolicitud(){

    var idSoli = $("#_Id_SolicitudAprobacion").val();
    var status = 99;
    var comentarios = $("#_txtmotivoCancelacion").val();
    var tipoCancelacion = $("#selectTipCancel").val();

    if (comentarios == "" || tipoCancelacion == "") {
      swal({
        type: "error",
        title: "¡Todos los campos marcados con * son necesarios",
        showConfirmButton: true,
        confirmButtonText: "Cerrar"
      }).then(function(result) {
        if (result.value) {}
      });
    }
    else {
      var dato = '{"id_solicitud":"' + idSoli + '",';
      dato += '"soli_motivoCancelacion":"' + comentarios + '",';
      dato += '"fk_id_cancelacion":"' + tipoCancelacion + '",';
      dato += '"fk_id_status":"' + status + '"}';
      var datos = new FormData();
      datos.append("cancelarSolicitud", dato);
      $.ajax({
        url: "ajax/solicitud.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta) {
          if (respuesta == "ok") {
            swal({
              type: "success",
              title: "¡Datos guardados correctamente!",
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {
                document.location = "solicitudes";
              }
            });
          } else {
            swal({
              type: "error",
              title: "¡Error al realizar petición!" + respuesta,
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
          }
        }
      });
    }


}


/*=================================================================
    SUBIR ARCHIVOS ADJUNTOS AL SERVIDOR AUN NO FUNCIONA
==================================================================*/
function subirArchivos(){
    //var id  = $("#_Id_Solicitud").val();
    var sPaginaURL = window.location.search.substring(1);
    var sURLVariables = sPaginaURL.split('&');
    var sp = sPaginaURL.split('&');
    var sp1 = sURLVariables[0].split('=');

    var formData = new FormData(document.getElementById("subir_archivos"));
      formData.append("dato", "valor");
      formData.append("id_solicitud_", sp1[1]);
  //  var datos = new FormData();

  //datos.append("guardarArchivo", value);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: formData,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "ok") {
          swal({
            type: "success",
            title: "¡Archivo subido correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {
              $(".loading").addClass('hidden');
            }
          });
          printTblAdjuntos();
        } else {
          swal({
            type: "error",
            title: "¡Error al realizar petición!" + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
            $(".loading").addClass('hidden');
        }
      }
    });
}

function printMateriales_enverSolicitudn() {
  var idtable = "_tblMateriales_EnVerSolicitud";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudVerSolicitud").val();
  var datos = new FormData();
  datos.append("_GetMateriales", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalMateriales_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_material'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mat_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mat_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mat_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['mat_importe'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total'] + "</td>";
        }
        else {
          print += "<td>" + respuesta[i]['mat_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['mat_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['mat_total']);
        TotalMateriales_USD = parseFloat(TotalMateriales_USD) + parseFloat(respuesta[i]['mat_total_dlls'])
      }

      var newTotalMX = TotalMateriales.toFixed(2);
      var newTotalUSD = TotalMateriales_USD.toFixed(2);

      $("#PrintPartidasMateriales_EnVerSolicitud").html(print);
      $("#_paratotales_enMateriales_Aprobacion").removeClass("hidden");
      $("._totalMaterial_MXN_G").html("$ " + newTotalMX);
      $("._totalMaterial_USD_G").html("$ " + newTotalUSD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printManoDeObra_EnverSolicitud() {
  var idtable = "_tblManoDeObra_enVerSolicitud";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudVerSolicitud").val();
  var datos = new FormData();
  datos.append("_GetManoDeObra", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalMateriales_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_mano_de_obra'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['mano_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['mano_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['mano_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['mano_importe'] + "</td>";
          print += "<td>" + respuesta[i]['mano_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['mano_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['mano_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['mano_total']);
        TotalMateriales_USD = parseFloat(TotalMateriales_USD) + parseFloat(respuesta[i]['mano_total_dlls']);
      }
      $("#PrintPartidasManoDeObra_EnVerSolicitud").html(print);
      $("#_paratotales_enManoDeObra_Aprobacion").removeClass("hidden");
      $("#_totalManoDeObra_EnAprobacion").html("$ " + TotalMateriales);
      $("#_totalManoDeObra_EnVerSolicitud").html("$ " + TotalMateriales);
      $("._totalManoDeObra_USD").html("$ " + TotalMateriales_USD);

      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printIndirectos_EnverSolicitud() {
  var idtable = "_tblIndirectos_enVerSolicitud";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudVerSolicitud").val();
  var datos = new FormData();
  datos.append("_GetIndirectos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var TotalIndirectos_USD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_indirecto'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ind_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ind_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ind_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['ind_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ind_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ind_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['ind_total']);
        TotalIndirectos_USD = parseFloat(TotalIndirectos_USD) + parseFloat(respuesta[i]['ind_total_dlls']);
      }
      $("#PrintPartidasIndirectos_EnVerSolicitud").html(print);
      $("#_paratotales_enIndirectos_Aprobacion").removeClass("hidden");
      $("#_totalIndirectos_EnVerSolicitud").html("$ " + TotalMateriales);
      $("._totalIndirectos_USD_G").html("$ " + TotalIndirectos_USD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printExternos_EnVerSolicitud() {
  var idtable = "_tblExternos_enVerSolicitud";
  DestroyTableGeneric_EnConceptos(idtable);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudVerSolicitud").val();
  var datos = new FormData();
  datos.append("_GetExternos", idSoli);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var subtotal = "";
      var iva = "";
      var total = "";
      var idcotidetalle = "";
      var TotalMateriales = 0;
      var totalExternosUSD = 0;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_gasto_externo'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['ext_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['ext_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['ext_descripcion'] + "</td>";
        if (respuesta[i]['fk_tipoMoneda'] == 1) {
          print += "<td>" + respuesta[i]['ext_importe'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['ext_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['ext_total_dlls'] + "</td>";
        }
        print += "<td>" + respuesta[i]['moneda_descripcion'] + "</td>";
        print += "</tr>";
        TotalMateriales = parseFloat(TotalMateriales) + parseFloat(respuesta[i]['ext_total']);
        totalExternosUSD = parseFloat(totalExternosUSD) + parseFloat(respuesta[i]['ext_total_dlls']);
      }
      $("#PrintPartidasExternos_EnVerSolicitud").html(print);
      $("#_paratotales_enExternos_Aprobacion").removeClass("hidden");
      $("#_totalExternos_EnVerSolicitud").html("$ " + TotalMateriales);
      $("._totalExternos_USD").html("$ " + totalExternosUSD);
      TableGeneric_EnConceptos(idtable);
    }
  })
}

function printConceptos_enverSolicitud() {
  var nameTabla = "tablaConceptos_enVerSolicitud";
  DestroyTableGeneral(nameTabla);
  var valor = 0;
  var idSoli = $("#_Id_SolicitudVerSolicitud").val();
  var datos = new FormData();
  datos.append("_GetConceptos", idSoli);

  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var moneda = $("#txtMoneda_EnVerSolicitud").val();
      var print = "";
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td class='hidden'>" + respuesta[i]['id_concepto'] + "</td>";
        print += "<td style='width:10px'>" + respuesta[i]['con_unidadDeMedida'] + "</td>";
        print += "<td>" + respuesta[i]['con_cantidad'] + "</td>";
        print += "<td>" + respuesta[i]['con_descripcion'] + "</td>";
        if (moneda == "MXN") {
          print += "<td>" + respuesta[i]['con_importe'] + "</td>";
          print += "<td>" + respuesta[i]['con_total'] + "</td>";
        }else {
          print += "<td>" + respuesta[i]['con_importe_dlls'] + "</td>";
          print += "<td>" + respuesta[i]['con_total_dlls'] + "</td>";
        }
        print += "</tr>";
      }
      $("#PrintPartidasConceptos_enVerSolicitud").html(print);
      TableGeneric_EnConceptos(nameTabla);
    }
  })
}


function CargarDatosParaEditEnVerSolicitud() {
  var id = $("#_Id_SolicitudVerSolicitud").val();
  var datos = new FormData();
  datos.append("_idSolicitud", id);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      $("#_Id_SolicitudVerSolicitud").val(respuesta["id_solicitud"]);
      $("#txtIdSolicitud_EnVerSolicitud").val(respuesta["soli_folio"]);
      $("#txt_tituloSolicitud_EnVerSolicitud").val(respuesta["soli_titulo"]);
      $("#txt_responsable_EnVerSolicitud").val(respuesta["us_nombre"]);
      $("#txt_empresa_EnVerSolicitud").val(respuesta["emp_nombre"]);
      $("#txt_contacto_EnVerSolicitud").val(respuesta["cont_nombre"]);
      $("#txtRFCEmpresa_EnVerSolicitud").val(respuesta["emp_rfc"]);
      var moneda = ""
      if (respuesta["soli_ultimo_tipoCambio"] == "1") {
        moneda = "MXN";
      }else {
        moneda = "USD";
      }
      if (respuesta["soli_ultimo_tipoCambio"] == null) {
        if (respuesta["id_divisa"] == "1") {
          moneda = "MXN";
        }else {
          moneda = "USD";
        }
      }
      if (respuesta["fk_id_status"] == "8") {
        $("._convierteAFolio").removeClass('hidden');
        $(".enviarCliente").addClass('hidden');
      }else if (respuesta["fk_id_status"] == "7") {
        $("._convierteAFolio").removeClass('hidden');
        $(".enviarCliente").removeClass('hidden');
      }

      $("#txtMoneda_EnVerSolicitud").val(moneda);
      $(".txtIDEmpresa_correo").val(respuesta["emp_nombre"]);
      $(".lblnomCont").val(respuesta["cont_nombre"]);
      //LLenar select con nombre de contactos por empresa
      GetContactosParaCorreo();
      //$("#txtContacto_correo").val(respuesta["cont_nombre"]);
      //$("#txtCuenta_correo").val(respuesta["cont_correo"]);
      $("#txtTipoServicio_EnVerSolicitud").val(respuesta["serv_descripcion"]);
      if (respuesta["soli_folio_Asimex"] !== "") {
        $("#txt_folioDeReferencia_EnVerSolicitud").val(respuesta["soli_folio_Asimex"]);
      } else {
        $("#txt_folioDeReferencia_EnVerSolicitud").val("N/A");
      }
      $("#_txtNotasDeVisita_EnVerSolicitud").val(respuesta["soli_desc_notasDeVisita"]);
      $("#txt_tiempoEntrega_enVerSolicitud").val(respuesta["soli_fechaEstimada_Entrega"]);


      if (respuesta["soli_sumatoria_materiales"] !== "" && respuesta["soli_sumatoria_materiales"] !== 0 && respuesta["soli_sumatoria_materiales"] !== null) {
        $("#_lblTotalMateriales_EnVerSolicitud").val(respuesta["soli_sumatoria_materiales"]);
      } else {
        $("#_lblTotalMateriales_EnVerSolicitud").val("0.00");
      }
      if (respuesta["soli_sumatoria_manoDeObra"] !== "" && respuesta["soli_sumatoria_manoDeObra"] !== 0 && respuesta["soli_sumatoria_manoDeObra"] !== null) {
        $("#_lblTotalManoDeObra_EnVerSolicitud").val(respuesta["soli_sumatoria_manoDeObra"]);
      } else {
        $("#_lblTotalManoDeObra_EnVerSolicitud").val("0.00");
      }
      if (respuesta["soli_sumatoria_indirectos"] !== "" && respuesta["soli_sumatoria_indirectos"] !== 0 && respuesta["soli_sumatoria_indirectos"] !== null) {
        $("#_lblTotalIndirectos_EnVerSolicitud").val(respuesta["soli_sumatoria_indirectos"]);
      } else {
        $("#_lblTotalIndirectos_EnVerSolicitud").val("0.00");
      }
      if (respuesta["soli_sumatoria_externos"] !== "" && respuesta["soli_sumatoria_externos"] !== 0 && respuesta["soli_sumatoria_externos"] !== null) {
        $("#_lblTotalExternos_EnVerSolicitud").val(respuesta["soli_sumatoria_externos"]);
      } else {
        $("#_lblTotalExternos_EnVerSolicitud").val("0.00");
      }
      $("#_lblTotalCostos_EnVerSolicitud").val(respuesta["soli_total"]);
      $("#_lblTotalUSD_EnVer").val(respuesta["soli_total_dlls"]);

      /*==================================================================*/
      var _moneda = respuesta["soli_ultimo_tipoCambio"];
      if (_moneda == "2") {
          $("#_subtotalSolicitud_EnVerSolicitud").val(respuesta["soli_subtotal_dlls"]);
        if (respuesta["soli_descuento_dlls"] !== "" && respuesta["soli_descuento_dlls"] !== 0 && respuesta["soli_descuento_dlls"] !== null) {
          $("#_descuentoSoli_EnVerSolicitud").val(respuesta["soli_descuento_dlls"]);
          $("#_subDescuentoSolicitud_enVerSolicitud").html(respuesta["soli_descuento_dlls"]);

        }
        if (respuesta["soli_iva_dlls"] !== "" && respuesta["soli_iva_dlls"] !== 0 && respuesta["soli_iva_dlls"] !== null) {
          $("#_IVaSoli_EnVerSolicitud").val(respuesta["soli_iva_dlls"]);
          $("#_IVASolicitud").html(respuesta["soli_iva_dlls"]);
        }

        $("#_totalSoli_EnVerSolicitud").val(respuesta["soli_totalFinal_dlls"]);
        if (respuesta["soli_subtotal_dlls"]) {
          var precioVenta = parseFloat(respuesta['soli_subtotal_dlls']) - parseFloat(respuesta['soli_descuento_dlls']);
          var new_precioVenta = precioVenta.toFixed(2);
          $("#_PrecioDeVentaSoli_EnVerSolicitud").val(new_precioVenta);
          var ganancias = parseFloat($("#_PrecioDeVentaSoli_EnVerSolicitud").val()) - parseFloat($("#_lblTotalUSD_EnVer").val());
          var new_ganancias = ganancias.toFixed(2);
          $("#_ganancias_EnVerSolicitud").val(new_ganancias);
        }
      }
      else {
          $("#_subtotalSolicitud_EnVerSolicitud").val(respuesta["soli_subtotal"]);
        if (respuesta["soli_descuento"] !== "" && respuesta["soli_descuento"] !== 0 && respuesta["soli_descuento"] !== null) {
          $("#_descuentoSoli_EnVerSolicitud").val(respuesta["soli_descuento"]);
          $("#_subDescuentoSolicitud_enVerSolicitud").html(respuesta["soli_descuento"]);

        }
        if (respuesta["soli_IVA"] !== "" && respuesta["soli_IVA"] !== 0 && respuesta["soli_IVA"] !== null) {
          $("#_IVaSoli_EnVerSolicitud").val(respuesta["soli_IVA"]);
          $("#_IVASolicitud").html(respuesta["soli_IVA"]);
        }

        $("#_totalSoli_EnVerSolicitud").val(respuesta["soli_totalFinal"]);
        if (respuesta["soli_subtotal"]) {
          var precioVenta = parseFloat(respuesta['soli_subtotal']) - parseFloat(respuesta['soli_descuento']);
          var new_precioVenta = precioVenta.toFixed(2);
          $("#_PrecioDeVentaSoli_EnVerSolicitud").val(new_precioVenta);
          var ganancias = parseFloat($("#_PrecioDeVentaSoli_EnVerSolicitud").val()) - parseFloat($("#_lblTotalCostos_EnVerSolicitud").val());
          var new_ganancias = ganancias.toFixed(2);
          $("#_ganancias_EnVerSolicitud").val(new_ganancias);
        }
      }
      $("._IndividualMat_mxn_G").html("$ " + respuesta['soli_sumInd_materiales_mxn']);
      $("._IndividualMat_usd_G").html("$ " + respuesta['soli_sumInd_materiales_dlls']);
      $("#txt_CantidadPzs_enVerSolicitud").val(respuesta['soli_cantidad_piezas']);
      $("._IndividualHrs_mano").html("$ " + respuesta['soli_sumInd_hrsUnitarias']);
      $("._IndividualMano_mxn").html("$ " + respuesta['soli_sumInd_manoDeObra_mxn']);
      $("._IndividualMano_usd").html("$ " + respuesta['soli_sumInd_manoDeObra_dlls']);
      $("._IndividualInd_mxn_G").html("$ " + respuesta['soli_sumInd_indirectos_mxn']);
      $("._IndividualInd_usd_G").html("$ " + respuesta['soli_sumInd_indirectos_dlls']);
      $("._IndividualExt_mxn").html("$ " + respuesta['soli_sumInd_externos_mxn']);
      $("._IndividualExt_usd").html("$ " + respuesta['soli_sumInd_externos_dlls']);

      $("#txt_tiempoEntregaAdmin_enVer").val(respuesta['soli_tiempo_entrega']);
      $("#txt_tipoCambio_enVer").val(respuesta['soli_tipoCambio_admin']);
      $("#_txtNotasCotizacion").val(respuesta['soli_notas_cotizacion']);
    }
  });

}
/*=============================================
    btn para guardar contacto por ajax
=============================================*/
$(document).on("click", "#btnPrintSolicitud", function(){
  var notas = $("#_txtNotasCotizacion").val();
  if (notas !== "") {

    guardarComentarioCotizacion();

      var id = $("#_Id_SolicitudVerSolicitud").val();
      window.open("extentions/tcpdf/pdf/cotizacion-pdf.php?idSolicitud="+id, "_blank")


  }else {
    swal({
      type: "error",
      title: "¡Campo requerido!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  }

});

/*=================================================================
   SE APRUEBA LA SOLICITUD POR EL ROL DE GERENTE Y PASA A STATUS 6
==================================================================*/
function guardarComentarioCotizacion(){
  var idSoli = $("#_Id_SolicitudVerSolicitud").val();
  var notas = $("#_txtNotasCotizacion").val();
  var dato = '{"id_solicitud":"' + idSoli + '",';
  dato += '"soli_notas_cotizacion":"' + notas + '"}';
  var datos = new FormData();
  datos.append("notasCotizacion", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        /*swal({
          type: "success",
          title: "¡Solicitud aprobada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });*/

        return "ok";
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}


/*=============================================
  FUNCION PARA ENVIAR POR GET LA DIRECCION DE CORREO ELECTRONICO
=============================================*/
$(document).on("click", ".SendNameCorreo", function(){
  var valueCon = $("#txtCuenta_correo").val();
  var myCorreo = $("#_correoUsuario").val();
  if(valueCon !== "" && valueCon !== undefined && valueCon !== "Seleccione un contacto"){
    var idSoli = $("#_Id_SolicitudVerSolicitud").val();
    //$("#nuevaNotas").val();
    var nameCorreo = $("#txtCuenta_correo").val();
    var conCopia = $("#txtCuentas_CC").val();
    document.location = "extentions/PHPMailer/SendEmail.php?correo="+nameCorreo+"&idMaster="+idSoli+"&oculta="+myCorreo+"&cc="+conCopia+"";
  }else {
      swal({
        type: "error",
        title: "¡Es necesario colocar una cuenta de correo electronico!",
        showConfirmButton: true,
        confirmButtonText: "Cerrar"
      }).then(function(result) {
        if (result.value) {}
      });
  }

});

function printTblAdjuntos() {
  var idtable = "tbl_adjuntos";
  DestroyTableGeneric_EnConceptos(idtable);

  var sPaginaURL = window.location.search.substring(1);
  var sURLVariables = sPaginaURL.split('&');
  var sp = sPaginaURL.split('&');
  var sp1 = sURLVariables[0].split('=');

//  var idSoli = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("_GetNameFile", sp1[1]);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var idcotidetalle = "";
      var contador = 1;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td style='width:5px'>" + contador + "</td>";
        //print += "<td style='width:20px'><a href='http://rioswebservices.com/files/asimx/test/" + respuesta[i]['adjunto_nombre'] + "' target='_blank'>" + respuesta[i]['adjunto_nombre'] + "</a></td>";
        //print += "<td style='width:20px'><a href='http://www.apise.com.mx/apise-os/files/" + respuesta[i]['adjunto_nombre'] + "' target='_blank'>" + respuesta[i]['adjunto_nombre'] + "</a></td>";
        print += "<td style='width:20px'><a href='../Asimex/files/" + respuesta[i]['adjunto_nombre'] + "' target='_blank'>" + respuesta[i]['adjunto_nombre'] + "</a></td>";
        print += "<div class='btn-group'>";
        print += "<td style='width:10px'><a class='btn btn-info btnEliminar_' idName="+ respuesta[i]['adjunto_nombre'] +"><i class='fa fa-trash-o'></i></a></td>";
        print += "</div>";
        print += "</tr>";
        contador++;
      }
      $("#printAdjuntos").html(print);
      TableGeneric_EnConceptos(idtable);
   }
  })
}
/*=================================================================
    ELIMINAR ARCHIVOS ADJUNTOS DEL SERVIDOR
==================================================================*/
function EliminarArchivo(name){
      var sPaginaURL = window.location.search.substring(1);
      var sURLVariables = sPaginaURL.split('&');
      var sp = sPaginaURL.split('&');
      var sp1 = sURLVariables[0].split('=');
    //var id = $("#_Id_Solicitud").val();
    var dato = '{"id_solicitud":"' + sp1[1] + '",';
    dato += '"file_name":"' + name + '"}';
    var datos = new FormData();
    datos.append("_nameFile", dato);
    $.ajax({
      url: "ajax/solicitud.ajax.php",
      method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType: "json",
      success: function(respuesta) {
        if (respuesta == "ok") {
          swal({
            type: "success",
            title: "¡Archivo Eliminado Correctamente!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {

            }
          });
          printTblAdjuntos();
        } else {
          swal({
            type: "error",
            title: "¡Error al realizar petición!" + respuesta,
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
        }
      }
    });
}
/*=============================================
    btn para guardar contacto por ajax
=============================================*/
$(document).on("click", ".btnEliminar_", function(){
  var name = $(this).attr("idName");
  EliminarArchivo(name);
});


function GetContactosParaCorreo(){
  var empresa = $(".txtIDEmpresa_correo").val();
  var datos = new FormData();
  datos.append("_empresa", empresa);

  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
        if (respuesta.length == 0) {
          print = "<option>No existen contactos para esta empresa</option>";

        } else {
          print = "<option value=''>Seleccione un contacto</option>";
          for (var i = 0; i < respuesta.length; i++) {
            print += "<option value=" + respuesta[i]['cont_correo'] + ">";
            print += respuesta[i]['cont_nombre'] + " - " + respuesta[i]['cont_puesto'] + " - " + respuesta[i]['cont_departamento'];
            print += "</option>";
          }
      }
      $("._selectContactosWhereID").html(print);
   }
  })
}
function cambiarTipoMoneda(){
  var id = $("#_Id_SolicitudConceptos").val();
  var tipo = $("#_cambiarTipoMoneda").val();

  var dato = '{"id_solicitud":"' + id + '",';
  dato += '"soli_ultimo_tipoCambio":"' + tipo + '"}';
  var datos = new FormData();
  datos.append("_cambiaTipoMoneda", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Tipo de moneda cambiado correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {

          }
        });
        CargarDatosParaEditEnConceptos();
        printMateriales_EnConceptos();
        printManoDeObra_EnConceptos();
        printIndirectos_EnConceptos();
        printExternos_EnConceptos();
        printConceptos();
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }

   }
  })
}

function printTblHistorialCorreos() {
  var idtable = "tabla_HistorialCorreos";
  DestroyTableGeneric_EnConceptos(idtable);

  var sPaginaURL = window.location.search.substring(1);
  var sURLVariables = sPaginaURL.split('&');
  var sp = sPaginaURL.split('&');
  var sp1 = sURLVariables[0].split('=');

//  var idSoli = $("#_Id_Solicitud").val();
  var datos = new FormData();
  datos.append("_GetHistorialCorreo", sp1[1]);
  // SE UTILIZA AJAX PARA CARGAR LA INFO SIN REFRESCAR LA PAGINA
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var print = "";
      var idcotidetalle = "";
      var contador = 1;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td style='width:5px'>" + contador + "</td>";
        print += "<td>" + respuesta[i]['soli_folio'] + "</a></td>";
        print += "<td>" + respuesta[i]['soli_titulo'] + "</a></td>";
        print += "<td>" + respuesta[i]['historial_enviadoA'] + "</a></td>";
        print += "<td>" + respuesta[i]['soli_totalFinal'] + "</a></td>";
        print += "<td>" + respuesta[i]['soli_totalFinal_dlls'] + "</a></td>";
        print += "<td>" + respuesta[i]['historial_fecha'] + "</a></td>";
        print += "</tr>";
        contador++;
      }
      $("#printHistorialCorreos").html(print);
      TableGeneric_EnConceptos(idtable);
   }
  })
}
function convertirAFolio(){
  var bandera = 0;
  var id = $("#_Id_SolicitudVerSolicitud").val();
  var forma_aprobacion = $("#_selectFormaDeAprobacion").val();
  var ordenCompra = $("#txtOrdenDeCompra").val();
  var comentario = $("#txtComentarioAprobacion").val();
  var nombre_completo = $("._us_nombre_user").val();
  if (forma_aprobacion == "") {
    swal({
      type: "error",
      title: "¡Todos los campos marcados con * son requeridos!",
      showConfirmButton: true,
      confirmButtonText: "Cerrar"
    }).then(function(result) {
      if (result.value) {}
    });
  }else {
    if (forma_aprobacion == "1") {
        if (ordenCompra == "") {
          swal({
            type: "error",
            title: "¡Numero de orden de compra requerida!",
            showConfirmButton: true,
            confirmButtonText: "Cerrar"
          }).then(function(result) {
            if (result.value) {}
          });
          bandera = 1;
        }
    }else {
      if (ordenCompra == "") {
        ordenCompra = "Sin Orden de Compra";
      }
      if (comentario == "") {
        swal({
          type: "error",
          title: "¡Comentario requerido!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
        bandera = 1;
      }
    }
    if (bandera == 0) {
      if (comentario == "") {
        comentario = "N/A";
      }
      var dato = '{"id_solicitud":"' + id + '",';
      dato += '"fk_id_forma_aprobacion":"' + forma_aprobacion + '",';
      dato += '"soli_orden_de_compra":"' + ordenCompra + '",';
      dato += '"soli_razonAprobacionSinOC":"' + comentario + '",';
      dato += '"name_user":"' + nombre_completo + '"}';


      var datos = new FormData();
      datos.append("_convertirAFolio", dato);
      $.ajax({
        url: "ajax/solicitud.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta) {
          if (respuesta !== "") {
            swal({
              type: "success",
              title: "¡Datos guardados correctamente",
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {
                  document.location = "solicitudes";
              }
            });
          }
          else {
            swal({
              type: "error",
              title: "¡Error al realizar petición!" + respuesta,
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
          }
       }
      })
    }
  }
}

function enviarAAdmin(){
  var sPaginaURL = window.location.search.substring(1);
  var sURLVariables = sPaginaURL.split('&');
  var sp = sPaginaURL.split('&');
  var sp1 = sURLVariables[0].split('=');

  var status = 4;
  var dato = '{"id_solicitud":"' + sp1[1] + '",';
  dato += '"fk_id_status":"' + status + '"}';
  var datos = new FormData();
  datos.append("_EnviaraAdmin", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Datos guardados correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {
            document.location = "solicitudes";
          }
        });
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

function enviarAVentas(){
  var sPaginaURL = window.location.search.substring(1);
  var sURLVariables = sPaginaURL.split('&');
  var sp = sPaginaURL.split('&');
  var sp1 = sURLVariables[0].split('=');

  var status = 3;
  var dato = '{"id_solicitud":"' + sp1[1] + '",';
  dato += '"fk_id_status":"' + status + '"}';
  var datos = new FormData();
  datos.append("_EnviaraVentas", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Datos guardados correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {
            document.location = "solicitudes";
          }
        });
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}

$(document).on("click", "#_btnActualizarTituloSOLI", function(){
  ActualizarTituloSoli();
});
function ActualizarTituloSoli() {
  var sPaginaURL = window.location.search.substring(1);
  var sURLVariables = sPaginaURL.split('&');
  var sp = sPaginaURL.split('&');
  var sp1 = sURLVariables[0].split('=');

  var titulo = $("#txt_tituloSolicitud").val();
  var dato = '{"id_solicitud":"' + sp1[1] + '",';
  dato += '"soli_titulo":"' + titulo + '"}';
  var datos = new FormData();
  datos.append("ActualizarTituloSoli_", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Datos Actualiados Correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {
          }
        });
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}
/*ACTIVAR MODAL*/
$(document).on("click", ".btnShowModal", function() {
  var idPartida = $(this).attr("idSolicitud");
  $("#lbl_idSolicitud").val(idPartida);
  $("#modalSolicitud").modal('show');
});
/*ACTIVAR SECCION PARA REPROGRAMAR VISITA*/
$(document).on("click", ".btnReprogramar", function() {
  $("._divReprogramar").removeClass('hidden');
  $(".btnUpdateDateVisit").removeClass('hidden');
  $(".btnEstimarCosto").addClass('hidden');
});
/*ENVIA A FORMULARIO DE ESTIMACION DE COSTOS*/
$(document).on("click", ".btnEstimarCosto", function() {
  var id_so = $("#lbl_idSolicitud").val();
  document.location = "detallesSolicitud?EditSoli="+ id_so;
});
/*ACTUALIZAR FECHA DE VISITA*/
$(document).on("click", ".btnUpdateDateVisit", function() {
    var id_so = $("#lbl_idSolicitud").val();
    var fecha = $("#fechaDeVisitaRep").val();
    var fechaVisita = $("#fechaDeVisitaRep").val() + " " + $("#horaVisitaRep").val();
    var coment = $("#txtComReprogramacion").val();
    var usuario = $("#_us_name_soli").val();

    if (fechaVisita == "" || coment == "" || fecha == "") {
      swal({
        type: "error",
        title: "¡Todos los campos marcados con * son requeridos!",
        showConfirmButton: true,
        confirmButtonText: "Cerrar"
      }).then(function(result) {
        if (result.value) {}
      });
    }else {
      var dato = '{"id_solicitud":"' + id_so + '",';
      dato += '"soli_fecha_visita":"' + fechaVisita + '",';
      dato += '"movSoli_comentario":"' + coment + '",';
      dato += '"movSoli_creadoPor":"' + usuario + '"}';
      var datos = new FormData();
      datos.append("UpdateFechaVisita_", dato);
      $.ajax({
        url: "ajax/solicitud.ajax.php",
        method: "POST",
        data: datos,
        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function(respuesta) {
          if (respuesta == "ok") {
            swal({
              type: "success",
              title: "¡Vista reprogramada correctamente!",
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {
              }
              document.location = "solicitudes";
            });
          } else {
            swal({
              type: "error",
              title: "¡Error al realizar petición!" + respuesta,
              showConfirmButton: true,
              confirmButtonText: "Cerrar"
            }).then(function(result) {
              if (result.value) {}
            });
          }
        }
      });
    }

});

/*ABRIR MODAL PARA VER EL LOG DEL FOLIO*/
$(document).on("click", ".btnModalHistorial", function() {
  var idPartida = $(this).attr("idSolicitud");
  $("#modalHIstorialSoli").modal('show');
  getHistorySoli(idPartida)
});
function getHistorySoli(idPartida) {
  var idtable = "tbl_historial_solicitud";
  DestroyTableGeneric_EnConceptos(idtable);

  var datos = new FormData();
  datos.append("GetHistorySoli_", idPartida);

  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      var cont = 1;
      for (var i = 0; i < respuesta.length; i++) {
        print += "<tr>";
        print += "<td style='width:10px'> "+ cont +" </td>";
        print += "<td>" + respuesta[i]['movSoli_modulo'] + "</td>";
        print += "<td>" + respuesta[i]['movSoli_comentario'] + "</td>";
        print += "<td>" + respuesta[i]['movSoli_creadoPor'] + "</td>";
        print += "</tr>";
        cont++;
      }
      $("#printMovSoli").html(print);
      TableGeneric_EnConceptos(idtable);
    }
  });
}
/*==================================================================================
    ASIGNAR SOLICITUD A UN RESPONSABLE
===================================================================================*/
$(document).on("click", ".AsignarSolicitud", function() {
  var idPartida = $(this).attr("idSolicitud");
  $("#modalAsignarReponsable").modal('show');
  GetDatosAsignacion(idPartida);
});

/*==================================================================================
  ====EDITAR UNA SOLICITUD ENVIANDO ID DESDE EL LISTDO PRINCIPAL==================
===================================================================================*/
$(document).on("click", ".EditarSolicitud", function() {
  var idPartida = $(this).attr("idSolicitud");
  document.location = "detallesSolicitud?EditSoli=" + idPartida;
  //ssessionStorage._idSolicitudEdit = idPartida;
});
/*==================================================================================
    EDITAR UNA SOLICITUD CON STATUS POR COTIZAR where ID DESDE EL LISTDO PRINCIPAL
===================================================================================*/
$(document).on("click", ".EditarSoliAdmin", function() {
  //  document.location = "detallesConceptos";
    var idPartida = $(this).attr("idSolicitud");
    document.location = "detallesConceptos?EditConceptos=" + idPartida;
//    sessionStorage._idSoliEditConceptos = idPartida;
});
/*=======================================
    ABRIR EL APARTADO DE APROBACION X SOLICITUD
=========================================*/
$(document).on("click", ".AprobarSolicitud", function() {
  var idPartida = $(this).attr("idSolicitud");
  document.location = "aprobarSolicitud?AprobarSolicitud=" + idPartida;
});
/*=======================================
    ABRIR EL APARTADO PARA VER DETALLES DE LA SOLICITUDD
=========================================*/
$(document).on("click", ".InformacionGeneral", function() {
  var idPartida = $(this).attr("idSolicitud");
  sessionStorage._VerSolicitud = idPartida;
  //document.location = "verSolicitud";
  document.location = "verSolicitud?verSolicitud=" + idPartida;
});
/*=======================================
  ENVIAR O DESCARGAR SOLICITUD
=========================================*/
$(document).on("click", ".EnviarACliente", function() {
  var idPartida = $(this).attr("idSolicitud");
  sessionStorage._enviarSolicitud = idPartida;
  //    document.location = "verSolicitud";
  document.location = "verSolicitud?EnviarSolicitud=" + idPartida;
});
/*=======================================
  CONFIRMAR RECEPCION DE COTIZACION
=========================================*/
$(document).on("click", ".btnConfirmar", function() {
  swal({
    title: '¿Esta seguro de confirmar la recepción de está cotización?',
    text: "¡Usted puede cancelar la orden!",
    type: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    cancelButtonText: 'Cancelar',
    confirmButtonText: 'Si, Confirmar!'
  }).then(function(result) {
    if (result.value) {
      confirmarRecepcion();
    }
  });
});
function confirmarRecepcion() {
  var sPaginaURL = window.location.search.substring(1);
  var sURLVariables = sPaginaURL.split('&');
  var sp = sPaginaURL.split('&');
  var sp1 = sURLVariables[0].split('=');
  var status = "12";

  var dato = '{"id_solicitud":"' + sp1[1] + '",';
  dato += '"fk_id_status":"' + status + '"}';

  var datos = new FormData();
  datos.append("confirmarRecepcion_", dato);
  $.ajax({
    url: "ajax/solicitud.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta) {
      if (respuesta == "ok") {
        swal({
          type: "success",
          title: "¡Solicitud confirmada correctamente!",
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {
          }
          document.location = "solicitudes";
        });
      } else {
        swal({
          type: "error",
          title: "¡Error al realizar petición!" + respuesta,
          showConfirmButton: true,
          confirmButtonText: "Cerrar"
        }).then(function(result) {
          if (result.value) {}
        });
      }
    }
  });
}
